/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectHierarchyIterator
implements Iterator<ProjectState> {
    private static final Logger log = LoggerFactory.getLogger(ProjectHierarchyIterator.class);
    private final ProjectCache cache;
    private final AllProjectsName allProjectsName;
    private final Set<Project.NameKey> seen;
    private ProjectState next;

    ProjectHierarchyIterator(ProjectCache c, AllProjectsName all, ProjectState firstResult) {
        this.cache = c;
        this.allProjectsName = all;
        this.seen = Sets.newLinkedHashSet();
        this.seen.add(firstResult.getProject().getNameKey());
        this.next = firstResult;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ProjectState next() {
        ProjectState n = this.next;
        if (n == null) {
            throw new NoSuchElementException();
        }
        this.next = this.computeNext(n);
        return n;
    }

    private ProjectState computeNext(ProjectState n) {
        ProjectState p;
        Project.NameKey parentName = n.getProject().getParent();
        if (parentName != null && this.visit(parentName) && (p = this.cache.get(parentName)) != null) {
            return p;
        }
        if (this.seen.add(this.allProjectsName)) {
            return this.cache.get(this.allProjectsName);
        }
        return null;
    }

    private boolean visit(Project.NameKey parentName) {
        if (this.seen.add(parentName)) {
            return true;
        }
        ArrayList<String> order = Lists.newArrayListWithCapacity(this.seen.size() + 1);
        for (Project.NameKey p : this.seen) {
            order.add(p.get());
        }
        int idx = order.lastIndexOf(parentName.get());
        order.add(parentName.get());
        log.warn("Cycle detected in projects: " + Joiner.on(" -> ").join(order.subList(idx, order.size())));
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

