/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.common.InheritableBoolean;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityCollection;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.BranchOrderSection;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.ProjectLevelConfig;
import com.google.gerrit.server.project.CommentLinkInfo;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectHierarchyIterator;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.gerrit.server.project.ThemeInfo;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.googlecode.prolog_cafe.compiler.CompileException;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectState {
    private static final Logger log = LoggerFactory.getLogger(ProjectState.class);
    private final boolean isAllProjects;
    private final SitePaths sitePaths;
    private final AllProjectsName allProjectsName;
    private final ProjectCache projectCache;
    private final ProjectControl.AssistedFactory projectControlFactory;
    private final PrologEnvironment.Factory envFactory;
    private final GitRepositoryManager gitMgr;
    private final RulesCache rulesCache;
    private final List<CommentLinkInfo> commentLinks;
    private final ProjectConfig config;
    private final Map<String, ProjectLevelConfig> configs;
    private final Set<AccountGroup.UUID> localOwners;
    private volatile PrologMachineCopy rulesMachine;
    private volatile long lastCheckTime;
    private volatile List<SectionMatcher> localAccessSections;
    private volatile ThemeInfo theme;
    private final CapabilityCollection capabilities;

    @Inject
    public ProjectState(SitePaths sitePaths, ProjectCache projectCache, AllProjectsName allProjectsName, ProjectControl.AssistedFactory projectControlFactory, PrologEnvironment.Factory envFactory, GitRepositoryManager gitMgr, RulesCache rulesCache, List<CommentLinkInfo> commentLinks, @Assisted ProjectConfig config) {
        this.sitePaths = sitePaths;
        this.projectCache = projectCache;
        this.isAllProjects = config.getProject().getNameKey().equals(allProjectsName);
        this.allProjectsName = allProjectsName;
        this.projectControlFactory = projectControlFactory;
        this.envFactory = envFactory;
        this.gitMgr = gitMgr;
        this.rulesCache = rulesCache;
        this.commentLinks = commentLinks;
        this.config = config;
        this.configs = Maps.newHashMap();
        CapabilityCollection capabilityCollection = this.capabilities = this.isAllProjects ? new CapabilityCollection(config.getAccessSection("GLOBAL_CAPABILITIES")) : null;
        if (this.isAllProjects && !Permission.canBeOnAllProjects("refs/*", "owner")) {
            this.localOwners = Collections.emptySet();
        } else {
            Permission owner;
            HashSet<AccountGroup.UUID> groups = new HashSet<AccountGroup.UUID>();
            AccessSection all = config.getAccessSection("refs/*");
            if (all != null && (owner = all.getPermission("owner")) != null) {
                for (PermissionRule rule : owner.getRules()) {
                    GroupReference ref = rule.getGroup();
                    if (rule.getAction() != PermissionRule.Action.ALLOW || ref.getUUID() == null) continue;
                    groups.add(ref.getUUID());
                }
            }
            this.localOwners = Collections.unmodifiableSet(groups);
        }
    }

    boolean needsRefresh(long generation) {
        if (generation <= 0L) {
            return this.isRevisionOutOfDate();
        }
        if (this.lastCheckTime != generation) {
            this.lastCheckTime = generation;
            return this.isRevisionOutOfDate();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRevisionOutOfDate() {
        try (Repository git = this.gitMgr.openRepository(this.getProject().getNameKey());){
            Ref ref = git.getRef("refs/meta/config");
            if (ref == null || ref.getObjectId() == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = !ref.getObjectId().equals(this.config.getRevision());
            return bl;
        }
        catch (IOException gone) {
            return true;
        }
    }

    public CapabilityCollection getCapabilityCollection() {
        return this.capabilities;
    }

    public PrologEnvironment newPrologEnvironment() throws CompileException {
        PrologMachineCopy pmc = this.rulesMachine;
        if (pmc == null) {
            this.rulesMachine = pmc = this.rulesCache.loadMachine(this.getProject().getNameKey(), this.config.getRulesId());
        }
        return this.envFactory.create(pmc);
    }

    public PrologEnvironment newPrologEnvironment(String name, InputStream in) throws CompileException {
        PrologMachineCopy pmc = this.rulesCache.loadMachine(name, in);
        return this.envFactory.create(pmc);
    }

    public Project getProject() {
        return this.config.getProject();
    }

    public ProjectConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectLevelConfig getConfig(String fileName) {
        if (this.configs.containsKey(fileName)) {
            return this.configs.get(fileName);
        }
        ProjectLevelConfig cfg = new ProjectLevelConfig(fileName, this);
        try (Repository git = this.gitMgr.openRepository(this.getProject().getNameKey());){
            cfg.load(git);
        }
        catch (IOException e) {
            log.warn("Failed to load " + fileName + " for " + this.getProject().getName(), e);
        }
        catch (ConfigInvalidException e) {
            log.warn("Failed to load " + fileName + " for " + this.getProject().getName(), e);
        }
        this.configs.put(fileName, cfg);
        return cfg;
    }

    public long getMaxObjectSizeLimit() {
        return this.config.getMaxObjectSizeLimit();
    }

    List<SectionMatcher> getLocalAccessSections() {
        List<SectionMatcher> sm = this.localAccessSections;
        if (sm == null) {
            Collection<AccessSection> fromConfig = this.config.getAccessSections();
            sm = new ArrayList<SectionMatcher>(fromConfig.size());
            for (AccessSection section : fromConfig) {
                SectionMatcher matcher;
                if (this.isAllProjects) {
                    ArrayList<Permission> copy = Lists.newArrayListWithCapacity(section.getPermissions().size());
                    for (Permission p : section.getPermissions()) {
                        if (!Permission.canBeOnAllProjects(section.getName(), p.getName())) continue;
                        copy.add(p);
                    }
                    section = new AccessSection(section.getName());
                    section.setPermissions(copy);
                }
                if ((matcher = SectionMatcher.wrap(this.getProject().getNameKey(), section)) == null) continue;
                sm.add(matcher);
            }
            this.localAccessSections = sm;
        }
        return sm;
    }

    List<SectionMatcher> getAllSections() {
        if (this.isAllProjects) {
            return this.getLocalAccessSections();
        }
        ArrayList<SectionMatcher> all = Lists.newArrayList();
        for (ProjectState s : this.tree()) {
            all.addAll(s.getLocalAccessSections());
        }
        return all;
    }

    public Set<AccountGroup.UUID> getOwners() {
        for (ProjectState p : this.tree()) {
            if (p.localOwners.isEmpty()) continue;
            return p.localOwners;
        }
        return Collections.emptySet();
    }

    boolean isOwner(final GroupMembership groups) {
        return Iterables.any(this.tree(), new Predicate<ProjectState>(){

            @Override
            public boolean apply(ProjectState in) {
                return groups.containsAnyOf(in.localOwners);
            }
        });
    }

    public ProjectControl controlFor(CurrentUser user) {
        return this.projectControlFactory.create(user, this);
    }

    public Iterable<ProjectState> tree() {
        return new Iterable<ProjectState>(){

            @Override
            public Iterator<ProjectState> iterator() {
                return new ProjectHierarchyIterator(ProjectState.this.projectCache, ProjectState.this.allProjectsName, ProjectState.this);
            }
        };
    }

    public Iterable<ProjectState> treeInOrder() {
        ArrayList<ProjectState> projects = Lists.newArrayList(this.tree());
        Collections.reverse(projects);
        return projects;
    }

    public Iterable<ProjectState> parents() {
        return Iterables.skip(this.tree(), 1);
    }

    public boolean isAllProjects() {
        return this.isAllProjects;
    }

    public boolean isUseContributorAgreements() {
        return this.getInheritableBoolean(new Function<Project, InheritableBoolean>(){

            @Override
            public InheritableBoolean apply(Project input) {
                return input.getUseContributorAgreements();
            }
        });
    }

    public boolean isUseContentMerge() {
        return this.getInheritableBoolean(new Function<Project, InheritableBoolean>(){

            @Override
            public InheritableBoolean apply(Project input) {
                return input.getUseContentMerge();
            }
        });
    }

    public boolean isUseSignedOffBy() {
        return this.getInheritableBoolean(new Function<Project, InheritableBoolean>(){

            @Override
            public InheritableBoolean apply(Project input) {
                return input.getUseSignedOffBy();
            }
        });
    }

    public boolean isRequireChangeID() {
        return this.getInheritableBoolean(new Function<Project, InheritableBoolean>(){

            @Override
            public InheritableBoolean apply(Project input) {
                return input.getRequireChangeID();
            }
        });
    }

    public LabelTypes getLabelTypes() {
        LinkedHashMap<String, LabelType> types = Maps.newLinkedHashMap();
        for (ProjectState s : this.treeInOrder()) {
            for (LabelType type : s.getConfig().getLabelSections().values()) {
                String lower = type.getName().toLowerCase();
                LabelType old = (LabelType)types.get(lower);
                if (old != null && !old.canOverride()) continue;
                types.put(lower, type);
            }
        }
        ArrayList<LabelType> all = Lists.newArrayListWithCapacity(types.size());
        for (LabelType type : types.values()) {
            if (type.getValues().isEmpty()) continue;
            all.add(type);
        }
        return new LabelTypes(Collections.unmodifiableList(all));
    }

    public List<CommentLinkInfo> getCommentLinks() {
        LinkedHashMap<String, CommentLinkInfo> cls = Maps.newLinkedHashMap();
        for (CommentLinkInfo cl : this.commentLinks) {
            cls.put(cl.name.toLowerCase(), cl);
        }
        for (ProjectState s : this.treeInOrder()) {
            for (CommentLinkInfo cl : s.getConfig().getCommentLinkSections()) {
                String name = cl.name.toLowerCase();
                if (cl.isOverrideOnly()) {
                    CommentLinkInfo parent = (CommentLinkInfo)cls.get(name);
                    if (parent == null) continue;
                    cls.put(name, cl.inherit(parent));
                    continue;
                }
                cls.put(name, cl);
            }
        }
        return ImmutableList.copyOf(cls.values());
    }

    public BranchOrderSection getBranchOrderSection() {
        for (ProjectState s : this.tree()) {
            BranchOrderSection section = s.getConfig().getBranchOrderSection();
            if (section == null) continue;
            return section;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeInfo getTheme() {
        ThemeInfo theme = this.theme;
        if (theme == null) {
            ProjectState projectState = this;
            synchronized (projectState) {
                theme = this.theme;
                if (theme == null) {
                    this.theme = theme = this.loadTheme();
                }
            }
        }
        if (theme == ThemeInfo.INHERIT) {
            ProjectState parent = Iterables.getFirst(this.parents(), null);
            return parent != null ? parent.getTheme() : null;
        }
        return theme;
    }

    private ThemeInfo loadTheme() {
        String name = this.getConfig().getProject().getName();
        File dir = new File(this.sitePaths.themes_dir, name);
        if (!dir.exists()) {
            return ThemeInfo.INHERIT;
        }
        if (!dir.isDirectory()) {
            log.warn("Bad theme for {}: not a directory", (Object)name);
            return ThemeInfo.INHERIT;
        }
        try {
            return new ThemeInfo(this.readFile(new File(dir, "GerritSite.css")), this.readFile(new File(dir, "GerritSiteHeader.html")), this.readFile(new File(dir, "GerritSiteFooter.html")));
        }
        catch (IOException e) {
            log.error("Error reading theme for " + name, e);
            return ThemeInfo.INHERIT;
        }
    }

    private String readFile(File f) throws IOException {
        return f.exists() ? Files.toString(f, StandardCharsets.UTF_8) : null;
    }

    private boolean getInheritableBoolean(Function<Project, InheritableBoolean> func) {
        for (ProjectState s : this.tree()) {
            switch (func.apply(s.getProject())) {
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
            }
        }
        return false;
    }

    public static interface Factory {
        public ProjectState create(ProjectConfig var1);
    }
}

