/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.extensions.api.projects.ProjectState;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectRef;
import dk.brics.automaton.RegExp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

public class RefControl {
    private final ProjectControl projectControl;
    private final String refName;
    private final PermissionCollection relevant;
    private final Map<String, List<PermissionRule>> effective;
    private Boolean owner;
    private Boolean canForgeAuthor;
    private Boolean canForgeCommitter;
    private Boolean isVisible;

    RefControl(ProjectControl projectControl, String ref, PermissionCollection relevant) {
        this.projectControl = projectControl;
        this.refName = ref;
        this.relevant = relevant;
        this.effective = new HashMap<String, List<PermissionRule>>();
    }

    public String getRefName() {
        return this.refName;
    }

    public ProjectControl getProjectControl() {
        return this.projectControl;
    }

    public CurrentUser getCurrentUser() {
        return this.projectControl.getCurrentUser();
    }

    public RefControl forUser(CurrentUser who) {
        ProjectControl newCtl = this.projectControl.forUser(who);
        if (this.relevant.isUserSpecific()) {
            return newCtl.controlForRef(this.getRefName());
        }
        return new RefControl(newCtl, this.getRefName(), this.relevant);
    }

    public boolean isOwner() {
        if (this.owner == null) {
            this.owner = this.canPerform("owner") ? Boolean.valueOf(true) : Boolean.valueOf(this.projectControl.isOwner());
        }
        return this.owner;
    }

    public boolean isVisible() {
        if (this.isVisible == null) {
            this.isVisible = (this.getCurrentUser() instanceof InternalUser || this.canPerform("read")) && this.canRead();
        }
        return this.isVisible;
    }

    public boolean isVisibleByRegisteredUsers() {
        List<PermissionRule> access = this.relevant.getPermission("read");
        List<PermissionRule> overridden = this.relevant.getOverridden("read");
        HashSet<ProjectRef> allows = Sets.newHashSet();
        HashSet<ProjectRef> blocks = Sets.newHashSet();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!SystemGroupBackend.isAnonymousOrRegistered(rule.getGroup())) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!SystemGroupBackend.isAnonymousOrRegistered(rule.getGroup())) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && !allows.isEmpty();
    }

    public boolean canUpload() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("push") && this.canWrite();
    }

    public boolean canUploadMerges() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("pushMerge") && this.canWrite();
    }

    public boolean canRebase() {
        return this.canPerform("rebase") && this.canWrite();
    }

    public boolean canSubmit() {
        if ("refs/meta/config".equals(this.refName)) {
            return this.projectControl.isOwner();
        }
        return this.canPerform("submit") && this.canWrite();
    }

    public boolean canSubmitAs() {
        return this.canPerform("submitAs");
    }

    public boolean canUpdate() {
        if (!(!"refs/meta/config".equals(this.refName) || this.projectControl.isOwner() || this.projectControl.getProjectState().isAllProjects() && this.getCurrentUser().getCapabilities().canAdministrateServer())) {
            return false;
        }
        return this.canPerform("push") && this.canWrite();
    }

    public boolean canForceUpdate() {
        return (this.canPushWithForce() || this.canDelete()) && this.canWrite();
    }

    public boolean canWrite() {
        return this.getProjectControl().getProject().getState().equals((Object)ProjectState.ACTIVE);
    }

    public boolean canRead() {
        return this.getProjectControl().getProject().getState().equals((Object)ProjectState.READ_ONLY) || this.canWrite();
    }

    private boolean canPushWithForce() {
        if (!this.canWrite() || "refs/meta/config".equals(this.refName) && !this.projectControl.isOwner()) {
            return false;
        }
        return this.canForcePerform("push");
    }

    public boolean canCreate(RevWalk rw, RevObject object, boolean existsOnServer) {
        boolean admin;
        boolean owner;
        if (!this.canWrite()) {
            return false;
        }
        switch (this.getCurrentUser().getAccessPath()) {
            case REST_API: 
            case JSON_RPC: {
                owner = this.isOwner();
                admin = this.getCurrentUser().getCapabilities().canAdministrateServer();
                break;
            }
            default: {
                owner = false;
                admin = false;
            }
        }
        if (object instanceof RevCommit) {
            return admin || owner && !this.isBlocked("create") || this.canPerform("create") && (!existsOnServer && this.canUpdate() || this.projectControl.canReadCommit(rw, (RevCommit)object));
        }
        if (object instanceof RevTag) {
            RevTag tag = (RevTag)object;
            try {
                rw.parseBody(tag);
            }
            catch (IOException e) {
                return false;
            }
            PersonIdent tagger = tag.getTaggerIdent();
            if (tagger != null) {
                boolean valid;
                if (this.getCurrentUser().isIdentifiedUser()) {
                    IdentifiedUser user = (IdentifiedUser)this.getCurrentUser();
                    String addr = tagger.getEmailAddress();
                    valid = user.getEmailAddresses().contains(addr);
                } else {
                    valid = false;
                }
                if (!(valid || owner || this.canForgeCommitter())) {
                    return false;
                }
            }
            if (tag.getFullMessage().contains("-----BEGIN PGP SIGNATURE-----\n")) {
                return owner || this.canPerform("pushSignedTag");
            }
            return owner || this.canPerform("pushTag");
        }
        return false;
    }

    public boolean canDelete() {
        if (!this.canWrite() || "refs/meta/config".equals(this.refName)) {
            return false;
        }
        switch (this.getCurrentUser().getAccessPath()) {
            case REST_API: 
            case JSON_RPC: 
            case SSH_COMMAND: {
                return this.getCurrentUser().getCapabilities().canAdministrateServer() || this.isOwner() && !this.isForceBlocked("push") || this.canPushWithForce();
            }
            case GIT: {
                return this.canPushWithForce();
            }
        }
        return false;
    }

    public boolean canForgeAuthor() {
        if (this.canForgeAuthor == null) {
            this.canForgeAuthor = this.canPerform("forgeAuthor");
        }
        return this.canForgeAuthor;
    }

    public boolean canForgeCommitter() {
        if (this.canForgeCommitter == null) {
            this.canForgeCommitter = this.canPerform("forgeCommitter");
        }
        return this.canForgeCommitter;
    }

    public boolean canForgeGerritServerIdentity() {
        return this.canPerform("forgeServerAsCommitter");
    }

    public boolean canAbandon() {
        return this.canPerform("abandon");
    }

    public boolean canRemoveReviewer() {
        return this.canPerform("removeReviewer");
    }

    public boolean canViewDrafts() {
        return this.canPerform("viewDrafts");
    }

    public boolean canPublishDrafts() {
        return this.canPerform("publishDrafts");
    }

    public boolean canDeleteDrafts() {
        return this.canPerform("deleteDrafts");
    }

    public boolean canEditTopicName() {
        return this.canPerform("editTopicName");
    }

    public boolean canForceEditTopicName() {
        return this.canForcePerform("editTopicName");
    }

    public List<PermissionRange> getLabelRanges(boolean isChangeOwner) {
        ArrayList<PermissionRange> r = new ArrayList<PermissionRange>();
        for (Map.Entry<String, List<PermissionRule>> e : this.relevant.getDeclaredPermissions()) {
            if (!Permission.isLabel(e.getKey())) continue;
            int min = 0;
            int max = 0;
            for (PermissionRule rule : e.getValue()) {
                if (!this.projectControl.match(rule, isChangeOwner)) continue;
                min = Math.min(min, rule.getMin());
                max = Math.max(max, rule.getMax());
            }
            if (min == 0 && max == 0) continue;
            r.add(new PermissionRange(e.getKey(), min, max));
        }
        return r;
    }

    public PermissionRange getRange(String permission) {
        return this.getRange(permission, false);
    }

    public PermissionRange getRange(String permission, boolean isChangeOwner) {
        if (Permission.hasRange(permission)) {
            return this.toRange(permission, this.access(permission, isChangeOwner));
        }
        return null;
    }

    private PermissionRange toRange(String permissionName, List<PermissionRule> ruleList) {
        HashMap<ProjectRef, AllowedRange> ranges = Maps.newHashMap();
        for (PermissionRule rule : ruleList) {
            ProjectRef p = this.relevant.getRuleProps(rule);
            AllowedRange r = (AllowedRange)ranges.get(p);
            if (r == null) {
                r = new AllowedRange();
                ranges.put(p, r);
            }
            r.update(rule);
        }
        int allowMin = 0;
        int allowMax = 0;
        int blockMin = Integer.MIN_VALUE;
        int blockMax = Integer.MAX_VALUE;
        for (AllowedRange r : ranges.values()) {
            allowMin = Math.min(allowMin, r.getAllowMin());
            allowMax = Math.max(allowMax, r.getAllowMax());
            blockMin = Math.max(blockMin, r.getBlockMin());
            blockMax = Math.min(blockMax, r.getBlockMax());
        }
        int min = Math.max(allowMin, blockMin + 1);
        int max = Math.min(allowMax, blockMax - 1);
        return new PermissionRange(permissionName, min, max);
    }

    boolean canPerform(String permissionName) {
        return this.doCanPerform(permissionName, false);
    }

    public boolean isBlocked(String permissionName) {
        return !this.doCanPerform(permissionName, true);
    }

    private boolean doCanPerform(String permissionName, boolean blockOnly) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = Sets.newHashSet();
        HashSet<ProjectRef> blocks = Sets.newHashSet();
        for (PermissionRule rule : access) {
            if (rule.isBlock() && !rule.getForce().booleanValue()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && (!allows.isEmpty() || blockOnly);
    }

    private boolean canForcePerform(String permissionName) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = Sets.newHashSet();
        HashSet<ProjectRef> blocks = Sets.newHashSet();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!rule.getForce().booleanValue()) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!rule.getForce().booleanValue()) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && !allows.isEmpty();
    }

    private boolean isForceBlocked(String permissionName) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = Sets.newHashSet();
        HashSet<ProjectRef> blocks = Sets.newHashSet();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!rule.getForce().booleanValue()) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!rule.getForce().booleanValue()) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return !blocks.isEmpty();
    }

    private List<PermissionRule> access(String permissionName) {
        return this.access(permissionName, false);
    }

    private List<PermissionRule> access(String permissionName, boolean isChangeOwner) {
        List<PermissionRule> rules = this.effective.get(permissionName);
        if (rules != null) {
            return rules;
        }
        rules = this.relevant.getPermission(permissionName);
        if (rules.isEmpty()) {
            this.effective.put(permissionName, rules);
            return rules;
        }
        if (rules.size() == 1) {
            if (!this.projectControl.match(rules.get(0), isChangeOwner)) {
                rules = Collections.emptyList();
            }
            this.effective.put(permissionName, rules);
            return rules;
        }
        ArrayList<PermissionRule> mine = new ArrayList(rules.size());
        for (PermissionRule rule : rules) {
            if (!this.projectControl.match(rule, isChangeOwner)) continue;
            mine.add(rule);
        }
        if (mine.isEmpty()) {
            mine = Collections.emptyList();
        }
        this.effective.put(permissionName, mine);
        return mine;
    }

    public static boolean isRE(String refPattern) {
        return refPattern.startsWith("^");
    }

    public static String shortestExample(String pattern) {
        if (RefControl.isRE(pattern)) {
            return RefControl.toRegExp(pattern).toAutomaton().getShortestExample(true).replace('\u0000', '-');
        }
        if (pattern.endsWith("/*")) {
            return pattern.substring(0, pattern.length() - 1) + '1';
        }
        return pattern;
    }

    public static RegExp toRegExp(String refPattern) {
        if (RefControl.isRE(refPattern)) {
            refPattern = refPattern.substring(1);
        }
        return new RegExp(refPattern, 0);
    }

    public static void validateRefPattern(String refPattern) throws InvalidNameException {
        String prefix;
        if (refPattern.startsWith("^") ? !Repository.isValidRefName(RefControl.shortestExample(refPattern)) : !refPattern.equals("refs/*") && (refPattern.endsWith("/*") ? !Repository.isValidRefName(prefix = refPattern.substring(0, refPattern.length() - 2)) : !Repository.isValidRefName(refPattern))) {
            throw new InvalidNameException(refPattern);
        }
    }

    private static class AllowedRange {
        private int allowMin = 0;
        private int allowMax = 0;
        private int blockMin = Integer.MIN_VALUE;
        private int blockMax = Integer.MAX_VALUE;

        private AllowedRange() {
        }

        void update(PermissionRule rule) {
            if (rule.isBlock()) {
                this.blockMin = Math.max(this.blockMin, rule.getMin());
                this.blockMax = Math.min(this.blockMax, rule.getMax());
            } else {
                this.allowMin = Math.min(this.allowMin, rule.getMin());
                this.allowMax = Math.max(this.allowMax, rule.getMax());
            }
        }

        int getAllowMin() {
            return this.allowMin;
        }

        int getAllowMax() {
            return this.allowMax;
        }

        int getBlockMin() {
            return Math.min(this.blockMin, this.allowMin - 1);
        }

        int getBlockMax() {
            return Math.max(this.blockMax, this.allowMax + 1);
        }
    }
}

