/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.server.project.RefControl;
import dk.brics.automaton.Automaton;
import java.util.Collections;
import java.util.regex.Pattern;

public abstract class RefPatternMatcher {
    public static RefPatternMatcher getMatcher(String pattern) {
        if (pattern.contains("${")) {
            return new ExpandParameters(pattern);
        }
        if (RefControl.isRE(pattern)) {
            return new Regexp(pattern);
        }
        if (pattern.endsWith("/*")) {
            return new Prefix(pattern.substring(0, pattern.length() - 1));
        }
        return new Exact(pattern);
    }

    public abstract boolean match(String var1, String var2);

    static class ExpandParameters
    extends RefPatternMatcher {
        private final ParameterizedString template;
        private final String prefix;

        ExpandParameters(String pattern) {
            this.template = new ParameterizedString(pattern);
            if (RefControl.isRE(pattern)) {
                Automaton am = RefControl.toRegExp(this.template.replace(Collections.singletonMap("username", ":USERNAME:"))).toAutomaton();
                String rePrefix = am.getCommonPrefix();
                this.prefix = rePrefix.substring(0, rePrefix.indexOf(":USERNAME:"));
            } else {
                this.prefix = pattern.substring(0, pattern.indexOf("${"));
            }
        }

        @Override
        public boolean match(String ref, String username) {
            if (!ref.startsWith(this.prefix) || username == null) {
                return false;
            }
            String u = RefControl.isRE(this.template.getPattern()) ? Pattern.quote(username) : username;
            RefPatternMatcher next = ExpandParameters.getMatcher(this.expand(this.template, u));
            return next != null ? next.match(this.expand(ref, u), username) : false;
        }

        boolean matchPrefix(String ref) {
            return ref.startsWith(this.prefix);
        }

        private String expand(String parameterizedRef, String userName) {
            if (parameterizedRef.contains("${")) {
                return this.expand(new ParameterizedString(parameterizedRef), userName);
            }
            return parameterizedRef;
        }

        private String expand(ParameterizedString parameterizedRef, String userName) {
            return parameterizedRef.replace(Collections.singletonMap("username", userName));
        }
    }

    private static class Regexp
    extends RefPatternMatcher {
        private final Pattern pattern;

        Regexp(String re) {
            this.pattern = Pattern.compile(re);
        }

        @Override
        public boolean match(String ref, String username) {
            return this.pattern.matcher(ref).matches();
        }
    }

    private static class Prefix
    extends RefPatternMatcher {
        private final String prefix;

        Prefix(String pfx) {
            this.prefix = pfx;
        }

        @Override
        public boolean match(String ref, String username) {
            return ref.startsWith(this.prefix);
        }
    }

    private static class Exact
    extends RefPatternMatcher {
        private final String expect;

        Exact(String name) {
            this.expect = name;
        }

        @Override
        public boolean match(String ref, String username) {
            return this.expect.equals(ref);
        }
    }
}

