/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.SetDefaultDashboard;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
class SetDashboard
implements RestModifyView<DashboardResource, Input> {
    private final Provider<SetDefaultDashboard> defaultSetter;

    @Inject
    SetDashboard(Provider<SetDefaultDashboard> defaultSetter) {
        this.defaultSetter = defaultSetter;
    }

    @Override
    public Object apply(DashboardResource resource, Input input) throws AuthException, BadRequestException, ResourceConflictException, MethodNotAllowedException, ResourceNotFoundException, IOException {
        if (resource.isProjectDefault()) {
            return this.defaultSetter.get().apply(resource, input);
        }
        throw new MethodNotAllowedException();
    }

    static class Input {
        @DefaultInput
        String id;
        String commitMessage;

        Input() {
        }
    }
}

