/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.DashboardsCollection;
import com.google.gerrit.server.project.GetDashboard;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.SetDashboard;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.kohsuke.args4j.Option;

class SetDefaultDashboard
implements RestModifyView<DashboardResource, SetDashboard.Input> {
    private final ProjectCache cache;
    private final MetaDataUpdate.Server updateFactory;
    private final DashboardsCollection dashboards;
    private final Provider<GetDashboard> get;
    @Option(name="--inherited", usage="set dashboard inherited by children")
    private boolean inherited;

    @Inject
    SetDefaultDashboard(ProjectCache cache, MetaDataUpdate.Server updateFactory, DashboardsCollection dashboards, Provider<GetDashboard> get) {
        this.cache = cache;
        this.updateFactory = updateFactory;
        this.dashboards = dashboards;
        this.get = get;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response<DashboardsCollection.DashboardInfo> apply(DashboardResource resource, SetDashboard.Input input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, IOException {
        if (input == null) {
            input = new SetDashboard.Input();
        }
        input.id = Strings.emptyToNull(input.id);
        ProjectControl ctl = resource.getControl();
        IdentifiedUser user = (IdentifiedUser)ctl.getCurrentUser();
        if (!ctl.isOwner()) {
            throw new AuthException("not project owner");
        }
        DashboardResource target = null;
        if (input.id != null) {
            try {
                target = this.dashboards.parse(new ProjectResource(ctl), IdString.fromUrl(input.id));
            }
            catch (ResourceNotFoundException e) {
                throw new BadRequestException("dashboard " + input.id + " not found");
            }
            catch (ConfigInvalidException e) {
                throw new ResourceConflictException(e.getMessage());
            }
        }
        try (MetaDataUpdate md = this.updateFactory.create(ctl.getProject().getNameKey());){
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            if (this.inherited) {
                project.setDefaultDashboard(input.id);
            } else {
                project.setLocalDefaultDashboard(input.id);
            }
            String msg = Objects.firstNonNull(Strings.emptyToNull(input.commitMessage), input.id == null ? "Removed default dashboard.\n" : String.format("Changed default dashboard to %s.\n", input.id));
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            md.setAuthor(user);
            md.setMessage(msg);
            config.commit(md);
            this.cache.evict(ctl.getProject());
            if (target != null) {
                DashboardsCollection.DashboardInfo info = this.get.get().apply(target);
                info.isDefault = true;
                Response<DashboardsCollection.DashboardInfo> response = Response.ok(info);
                return response;
            }
            Response<DashboardsCollection.DashboardInfo> response = Response.none();
            return response;
        }
        catch (RepositoryNotFoundException notFound) {
            throw new ResourceNotFoundException(ctl.getProject().getName());
        }
        catch (ConfigInvalidException e) {
            throw new ResourceConflictException(String.format("invalid project.config: %s", e.getMessage()));
        }
    }

    static class CreateDefault
    implements RestModifyView<ProjectResource, SetDashboard.Input> {
        private final Provider<SetDefaultDashboard> setDefault;
        @Option(name="--inherited", usage="set dashboard inherited by children")
        private boolean inherited;

        @Inject
        CreateDefault(Provider<SetDefaultDashboard> setDefault) {
            this.setDefault = setDefault;
        }

        public Response<DashboardsCollection.DashboardInfo> apply(ProjectResource resource, SetDashboard.Input input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, IOException {
            SetDefaultDashboard set = this.setDefault.get();
            set.inherited = this.inherited;
            return set.apply(DashboardResource.projectDefault(resource.getControl()), input);
        }
    }
}

