/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.OperatorPredicate;

public abstract class IntPredicate<T>
extends OperatorPredicate<T> {
    private final int value;

    public IntPredicate(String name, String value) {
        super(name, value);
        this.value = Integer.parseInt(value);
    }

    public IntPredicate(String name, int value) {
        super(name, String.valueOf(value));
        this.value = value;
    }

    public int intValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.getOperator().hashCode() * 31 + this.value;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            IntPredicate p = (IntPredicate)other;
            return this.getOperator().equals(p.getOperator()) && this.intValue() == p.intValue();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getOperator() + ":" + this.getValue();
    }
}

