/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.Predicate;
import com.google.gwtorm.server.OrmException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class NotPredicate<T>
extends Predicate<T> {
    private final Predicate<T> that;

    protected NotPredicate(Predicate<T> that) {
        if (that instanceof NotPredicate) {
            throw new IllegalArgumentException("Double negation unsupported");
        }
        this.that = that;
    }

    @Override
    public final List<Predicate<T>> getChildren() {
        return Collections.singletonList(this.that);
    }

    @Override
    public final int getChildCount() {
        return 1;
    }

    @Override
    public final Predicate<T> getChild(int i) {
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.that;
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one child");
        }
        return new NotPredicate<T>(children.iterator().next());
    }

    @Override
    public boolean match(T object) throws OrmException {
        return !this.that.match(object);
    }

    @Override
    public int getCost() {
        return this.that.getCost();
    }

    @Override
    public int hashCode() {
        return ~this.that.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.getClass() == other.getClass() && this.getChildren().equals(((Predicate)other).getChildren());
    }

    public final String toString() {
        return "-" + this.that.toString();
    }
}

