/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.Predicate;
import com.google.gwtorm.server.OrmException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class VariablePredicate<T>
extends Predicate<T> {
    private final String name;
    private final Predicate<T> that;

    protected VariablePredicate(String name, Predicate<T> that) {
        this.name = name;
        this.that = that;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public final List<Predicate<T>> getChildren() {
        return Collections.singletonList(this.that);
    }

    @Override
    public final int getChildCount() {
        return 1;
    }

    @Override
    public final Predicate<T> getChild(int i) {
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.that;
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one child");
        }
        return new VariablePredicate<T>(this.getName(), children.iterator().next());
    }

    @Override
    public boolean match(T object) throws OrmException {
        return this.that.match(object);
    }

    @Override
    public int getCost() {
        return this.that.getCost();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() * 31 + this.that.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            VariablePredicate v = (VariablePredicate)other;
            return this.getName().equals(v.getName()) && this.getChildren().equals(v.getChildren());
        }
        return false;
    }

    public final String toString() {
        return this.getName() + "=(" + this.that.toString() + ")";
    }
}

