/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.query.IntPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryRewriter;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryRewriter;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.name.Named;

public class BasicChangeRewrites
extends QueryRewriter<ChangeData> {
    private static final ChangeQueryBuilder BUILDER = new ChangeQueryBuilder(new ChangeQueryBuilder.Arguments(new InvalidProvider<ReviewDb>(), new InvalidProvider<ChangeQueryRewriter>(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), null);
    private static final QueryRewriter.Definition<ChangeData, BasicChangeRewrites> mydef = new QueryRewriter.Definition<ChangeData, BasicChangeRewrites>(BasicChangeRewrites.class, BUILDER);
    protected final Provider<ReviewDb> dbProvider;

    @Inject
    public BasicChangeRewrites(Provider<ReviewDb> dbProvider) {
        super(mydef);
        this.dbProvider = dbProvider;
    }

    @QueryRewriter.Rewrite(value="-status:open")
    @QueryRewriter.NoCostComputation
    public Predicate<ChangeData> r00_notOpen() {
        return ChangeStatusPredicate.closed(this.dbProvider);
    }

    @QueryRewriter.Rewrite(value="-status:closed")
    @QueryRewriter.NoCostComputation
    public Predicate<ChangeData> r00_notClosed() {
        return ChangeStatusPredicate.open(this.dbProvider);
    }

    @QueryRewriter.NoCostComputation
    @QueryRewriter.Rewrite(value="-status:merged")
    public Predicate<ChangeData> r00_notMerged() {
        return this.or(ChangeStatusPredicate.open(this.dbProvider), new ChangeStatusPredicate(Change.Status.ABANDONED));
    }

    @QueryRewriter.NoCostComputation
    @QueryRewriter.Rewrite(value="-status:abandoned")
    public Predicate<ChangeData> r00_notAbandoned() {
        return this.or(ChangeStatusPredicate.open(this.dbProvider), new ChangeStatusPredicate(Change.Status.MERGED));
    }

    @QueryRewriter.NoCostComputation
    @QueryRewriter.Rewrite(value="A=(limit:*) B=(limit:*)")
    public Predicate<ChangeData> r00_smallestLimit(@Named(value="A") IntPredicate<ChangeData> a, @Named(value="B") IntPredicate<ChangeData> b) {
        return a.intValue() <= b.intValue() ? a : b;
    }

    private static final class InvalidProvider<T>
    implements Provider<T> {
        private InvalidProvider() {
        }

        @Override
        public T get() {
            throw new OutOfScopeException("Not available at init");
        }
    }
}

