/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.cache.Cache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.query.change.ConflictKey;
import com.google.gerrit.server.query.change.ConflictsCache;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;

@Singleton
public class ConflictsCacheImpl
implements ConflictsCache {
    public static final String NAME = "conflicts";
    private final Cache<ConflictKey, Boolean> conflictsCache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.persist(ConflictsCacheImpl.NAME, ConflictKey.class, Boolean.class).maximumWeight(37400L);
                this.bind(ConflictsCache.class).to(ConflictsCacheImpl.class);
            }
        };
    }

    @Inject
    public ConflictsCacheImpl(@Named(value="conflicts") Cache<ConflictKey, Boolean> conflictsCache) {
        this.conflictsCache = conflictsCache;
    }

    @Override
    public void put(ConflictKey key, Boolean value) {
        this.conflictsCache.put(key, value);
    }

    @Override
    public Boolean getIfPresent(ConflictKey key) {
        return this.conflictsCache.getIfPresent(key);
    }
}

