/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gwtorm.server.OrmException;

class EqualsFilePredicate
extends IndexPredicate<ChangeData> {
    private final String value;

    static Predicate<ChangeData> create(ChangeQueryBuilder.Arguments args, String value) {
        EqualsPathPredicate eqPath = new EqualsPathPredicate("file", value);
        if (!args.indexes.getSearchIndex().getSchema().getFields().containsKey(ChangeField.FILE_PART.getName())) {
            return eqPath;
        }
        return Predicate.or(eqPath, new EqualsFilePredicate(value));
    }

    private EqualsFilePredicate(String value) {
        super(ChangeField.FILE_PART, "file", value);
        this.value = value;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        return ChangeField.getFileParts(object).contains(this.value);
    }

    @Override
    public int getCost() {
        return 1;
    }
}

