/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;

class IsReviewedPredicate
extends IndexPredicate<ChangeData> {
    IsReviewedPredicate() {
        super(ChangeField.REVIEWED, "1");
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change c = object.change();
        if (c == null) {
            return false;
        }
        PatchSet.Id current = c.currentPatchSetId();
        for (PatchSetApproval p : object.approvals().get(current)) {
            if (p.getValue() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 2;
    }

    @Override
    public String toString() {
        return "is:reviewed";
    }
}

