/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;

class ProjectPredicate
extends IndexPredicate<ChangeData> {
    ProjectPredicate(String id) {
        super(ChangeField.PROJECT, id);
    }

    Project.NameKey getValueKey() {
        return new Project.NameKey(this.getValue());
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        if (change == null) {
            return false;
        }
        Project.NameKey p = change.getDest().getParentKey();
        return p.equals(this.getValueKey());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

