/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.QueryStatsAttribute;
import com.google.gerrit.server.events.EventFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.AndSource;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryRewriter;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gson.Gson;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryProcessor.class);
    private final Comparator<ChangeData> cmpAfter = new Comparator<ChangeData>(){

        @Override
        public int compare(ChangeData a, ChangeData b) {
            try {
                return a.change().getSortKey().compareTo(b.change().getSortKey());
            }
            catch (OrmException e) {
                return 0;
            }
        }
    };
    private final Comparator<ChangeData> cmpBefore = new Comparator<ChangeData>(){

        @Override
        public int compare(ChangeData a, ChangeData b) {
            try {
                return b.change().getSortKey().compareTo(a.change().getSortKey());
            }
            catch (OrmException e) {
                return 0;
            }
        }
    };
    private final Gson gson = new Gson();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    private final EventFactory eventFactory;
    private final ChangeQueryBuilder queryBuilder;
    private final ChangeQueryRewriter queryRewriter;
    private final Provider<ReviewDb> db;
    private final TrackingFooters trackingFooters;
    private final CurrentUser user;
    private final int maxLimit;
    private OutputFormat outputFormat = OutputFormat.TEXT;
    private int limit;
    private int start;
    private String sortkeyAfter;
    private String sortkeyBefore;
    private boolean includePatchSets;
    private boolean includeCurrentPatchSet;
    private boolean includeApprovals;
    private boolean includeComments;
    private boolean includeFiles;
    private boolean includeCommitMessage;
    private boolean includeDependencies;
    private boolean includeSubmitRecords;
    private boolean includeAllReviewers;
    private OutputStream outputStream = DisabledOutputStream.INSTANCE;
    private PrintWriter out;
    private boolean moreResults;

    @Inject
    QueryProcessor(EventFactory eventFactory, ChangeQueryBuilder.Factory queryBuilder, CurrentUser currentUser, ChangeQueryRewriter queryRewriter, Provider<ReviewDb> db, TrackingFooters trackingFooters) {
        this.eventFactory = eventFactory;
        this.queryBuilder = queryBuilder.create(currentUser);
        this.queryRewriter = queryRewriter;
        this.db = db;
        this.trackingFooters = trackingFooters;
        this.user = currentUser;
        this.maxLimit = currentUser.getCapabilities().getRange("queryLimit").getMax();
        this.moreResults = false;
    }

    int getLimit() {
        return this.limit;
    }

    void setLimit(int n) {
        this.limit = n;
    }

    public void setStart(int n) {
        this.start = n;
    }

    void setSortkeyAfter(String sortkey) {
        this.sortkeyAfter = sortkey;
    }

    void setSortkeyBefore(String sortkey) {
        this.sortkeyBefore = sortkey;
    }

    public void setIncludePatchSets(boolean on) {
        this.includePatchSets = on;
    }

    public boolean getIncludePatchSets() {
        return this.includePatchSets;
    }

    public void setIncludeCurrentPatchSet(boolean on) {
        this.includeCurrentPatchSet = on;
    }

    public boolean getIncludeCurrentPatchSet() {
        return this.includeCurrentPatchSet;
    }

    public void setIncludeApprovals(boolean on) {
        this.includeApprovals = on;
    }

    public void setIncludeComments(boolean on) {
        this.includeComments = on;
    }

    public void setIncludeFiles(boolean on) {
        this.includeFiles = on;
    }

    public boolean getIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeDependencies(boolean on) {
        this.includeDependencies = on;
    }

    public boolean getIncludeDependencies() {
        return this.includeDependencies;
    }

    public void setIncludeCommitMessage(boolean on) {
        this.includeCommitMessage = on;
    }

    public void setIncludeSubmitRecords(boolean on) {
        this.includeSubmitRecords = on;
    }

    public void setIncludeAllReviewers(boolean on) {
        this.includeAllReviewers = on;
    }

    public void setOutput(OutputStream out, OutputFormat fmt) {
        this.outputStream = out;
        this.outputFormat = fmt;
    }

    public List<ChangeData> queryChanges(String queryString) throws OrmException, QueryParseException {
        return this.queryChanges(ImmutableList.of(queryString)).get(0);
    }

    /*
     * WARNING - void declaration
     */
    public List<List<ChangeData>> queryChanges(List<String> queries) throws OrmException, QueryParseException {
        void var8_14;
        Predicate<ChangeData> visibleToMe = this.queryBuilder.is_visible();
        int cnt = queries.size();
        ArrayList<Integer> limits = Lists.newArrayListWithCapacity(cnt);
        ArrayList<AndSource> sources = Lists.newArrayListWithCapacity(cnt);
        for (String query : queries) {
            void var8_8;
            Predicate<ChangeData> predicate = this.parseQuery(query, visibleToMe);
            Predicate<ChangeData> s = this.queryRewriter.rewrite(predicate, this.start);
            if (!(s instanceof ChangeDataSource)) {
                Predicate<ChangeData> predicate2 = Predicate.and(this.queryBuilder.status_open(), predicate);
                s = this.queryRewriter.rewrite(predicate2, this.start);
            }
            if (!(s instanceof ChangeDataSource)) {
                throw new QueryParseException("invalid query: " + s);
            }
            AndSource a = new AndSource(ImmutableList.of(s, visibleToMe), this.start);
            limits.add(this.limit((Predicate<ChangeData>)var8_8));
            sources.add(a);
        }
        ArrayList matches = Lists.newArrayListWithCapacity(cnt);
        for (ChangeDataSource changeDataSource : sources) {
            matches.add(changeDataSource.read());
        }
        ArrayList<List<ChangeData>> out = Lists.newArrayListWithCapacity(cnt);
        boolean bl = false;
        while (var8_14 < cnt) {
            int limit;
            List results = ((ResultSet)matches.get((int)var8_14)).toList();
            if (this.sortkeyAfter != null) {
                Collections.sort(results, this.cmpAfter);
            } else if (this.sortkeyBefore != null) {
                Collections.sort(results, this.cmpBefore);
            }
            if (results.size() > this.maxLimit) {
                this.moreResults = true;
            }
            if ((limit = ((Integer)limits.get((int)var8_14)).intValue()) < results.size()) {
                results = results.subList(0, limit);
            }
            if (this.sortkeyAfter != null) {
                Collections.reverse(results);
            }
            out.add(results);
            ++var8_14;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String queryString) throws IOException {
        this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.outputStream, "UTF-8")));
        try {
            if (this.isDisabled()) {
                ErrorMessage m = new ErrorMessage();
                m.message = "query disabled";
                this.show(m);
                return;
            }
            try {
                QueryStatsAttribute stats = new QueryStatsAttribute();
                stats.runTimeMilliseconds = TimeUtil.nowMs();
                List<ChangeData> results = this.queryChanges(queryString);
                ChangeAttribute c = null;
                for (ChangeData d : results) {
                    PatchSet current;
                    ChangeControl cc = d.changeControl().forUser(this.user);
                    LabelTypes labelTypes = cc.getLabelTypes();
                    c = this.eventFactory.asChangeAttribute(d.change());
                    this.eventFactory.extend(c, d.change());
                    if (!this.trackingFooters.isEmpty()) {
                        this.eventFactory.addTrackingIds(c, this.trackingFooters.extract(d.commitFooters()));
                    }
                    if (this.includeAllReviewers) {
                        this.eventFactory.addAllReviewers(c, d.notes());
                    }
                    if (this.includeSubmitRecords) {
                        PatchSet.Id psId = d.change().currentPatchSetId();
                        PatchSet patchSet = this.db.get().patchSets().get(psId);
                        List<SubmitRecord> submitResult = cc.canSubmit(this.db.get(), patchSet, null, false, true, true);
                        this.eventFactory.addSubmitRecords(c, submitResult);
                    }
                    if (this.includeCommitMessage) {
                        this.eventFactory.addCommitMessage(c, d.commitMessage());
                    }
                    if (this.includePatchSets) {
                        if (this.includeFiles) {
                            this.eventFactory.addPatchSets(c, d.patches(), this.includeApprovals ? d.approvals().asMap() : null, this.includeFiles, d.change(), labelTypes);
                        } else {
                            this.eventFactory.addPatchSets(c, d.patches(), this.includeApprovals ? d.approvals().asMap() : null, labelTypes);
                        }
                    }
                    if (this.includeCurrentPatchSet && (current = d.currentPatchSet()) != null) {
                        c.currentPatchSet = this.eventFactory.asPatchSetAttribute(current);
                        this.eventFactory.addApprovals(c.currentPatchSet, d.currentApprovals(), labelTypes);
                        if (this.includeFiles) {
                            this.eventFactory.addPatchSetFileNames(c.currentPatchSet, d.change(), d.currentPatchSet());
                        }
                    }
                    if (this.includeComments) {
                        this.eventFactory.addComments(c, d.messages());
                        if (this.includePatchSets) {
                            for (PatchSetAttribute attribute : c.patchSets) {
                                this.eventFactory.addPatchSetComments(attribute, d.comments());
                            }
                        }
                    }
                    if (this.includeDependencies) {
                        this.eventFactory.addDependencies(c, d.change());
                    }
                    this.show(c);
                }
                stats.rowCount = results.size();
                if (this.moreResults) {
                    stats.resumeSortKey = c.sortKey;
                }
                stats.runTimeMilliseconds = TimeUtil.nowMs() - stats.runTimeMilliseconds;
                this.show(stats);
            }
            catch (OrmException err) {
                log.error("Cannot execute query: " + queryString, err);
                ErrorMessage m = new ErrorMessage();
                m.message = "cannot query database";
                this.show(m);
            }
            catch (QueryParseException e) {
                ErrorMessage m = new ErrorMessage();
                m.message = e.getMessage();
                this.show(m);
            }
            catch (NoSuchChangeException e) {
                log.error("Missing change: " + e.getMessage(), e);
                ErrorMessage m = new ErrorMessage();
                m.message = "missing change " + e.getMessage();
                this.show(m);
            }
        }
        finally {
            try {
                this.out.flush();
            }
            finally {
                this.out = null;
            }
        }
    }

    boolean isDisabled() {
        return this.maxLimit <= 0;
    }

    private int limit(Predicate<ChangeData> s) {
        int n = Objects.firstNonNull(ChangeQueryBuilder.getLimit(s), this.maxLimit);
        return this.limit > 0 ? Math.min(n, this.limit) + 1 : n + 1;
    }

    private Predicate<ChangeData> parseQuery(String queryString, Predicate<ChangeData> visibleToMe) throws QueryParseException {
        Predicate<ChangeData> q = this.queryBuilder.parse(queryString);
        if (this.queryBuilder.supportsSortKey() && !ChangeQueryBuilder.hasSortKey(q)) {
            q = this.sortkeyBefore != null ? Predicate.and(q, this.queryBuilder.sortkey_before(this.sortkeyBefore)) : (this.sortkeyAfter != null ? Predicate.and(q, this.queryBuilder.sortkey_after(this.sortkeyAfter)) : Predicate.and(q, this.queryBuilder.sortkey_before("z")));
        }
        return Predicate.and(q, this.queryBuilder.limit(this.limit > 0 ? Math.min(this.limit, this.maxLimit) + 1 : this.maxLimit), visibleToMe);
    }

    private void show(Object data) {
        switch (this.outputFormat) {
            default: {
                if (data instanceof ChangeAttribute) {
                    this.out.print("change ");
                    this.out.print(((ChangeAttribute)data).id);
                    this.out.print("\n");
                    this.showText(data, 1);
                } else {
                    this.showText(data, 0);
                }
                this.out.print('\n');
                break;
            }
            case JSON: {
                this.out.print(this.gson.toJson(data));
                this.out.print('\n');
            }
        }
    }

    private void showText(Object data, int depth) {
        for (Field f : this.fieldsOf(data.getClass())) {
            Object val;
            try {
                val = f.get(data);
            }
            catch (IllegalArgumentException err) {
                continue;
            }
            catch (IllegalAccessException err) {
                continue;
            }
            if (val == null) continue;
            this.showField(f.getName(), val, depth);
        }
    }

    private String indent(int spaces) {
        if (spaces == 0) {
            return "";
        }
        return String.format("%" + spaces + "s", " ");
    }

    private void showField(String field, Object value, int depth) {
        int spacesDepthRatio = 2;
        String indent = this.indent(depth * 2);
        this.out.print(indent);
        this.out.print(field);
        this.out.print(':');
        if (value instanceof String && ((String)value).contains("\n")) {
            this.out.print(' ');
            indent = this.indent(indent.length() + field.length() + 2);
            this.out.print(((String)value).replaceAll("\n", "\n" + indent).trim());
            this.out.print('\n');
        } else if (value instanceof Long && QueryProcessor.isDateField(field)) {
            this.out.print(' ');
            this.out.print(this.sdf.format(new Date((Long)value * 1000L)));
            this.out.print('\n');
        } else if (QueryProcessor.isPrimitive(value)) {
            this.out.print(' ');
            this.out.print(value);
            this.out.print('\n');
        } else if (value instanceof Collection) {
            this.out.print('\n');
            boolean firstElement = true;
            for (Object thing : (Collection)value) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    this.out.print(indent);
                    this.out.print(field);
                    this.out.print(":\n");
                }
                if (QueryProcessor.isPrimitive(thing)) {
                    this.out.print(' ');
                    this.out.print(value);
                    this.out.print('\n');
                    continue;
                }
                this.showText(thing, depth + 1);
            }
        } else {
            this.out.print('\n');
            this.showText(value, depth + 1);
        }
    }

    private static boolean isPrimitive(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Enum;
    }

    private static boolean isDateField(String name) {
        return "lastUpdated".equals(name) || "grantedOn".equals(name) || "timestamp".equals(name) || "createdOn".equals(name);
    }

    private List<Field> fieldsOf(Class<?> type) {
        ArrayList<Field> r = new ArrayList<Field>();
        if (type.getSuperclass() != null) {
            r.addAll(this.fieldsOf(type.getSuperclass()));
        }
        r.addAll(Arrays.asList(type.getDeclaredFields()));
        return r;
    }

    static class ErrorMessage {
        public final String type = "error";
        public String message;

        ErrorMessage() {
        }
    }

    public static enum OutputFormat {
        TEXT,
        JSON;

    }
}

