/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;

class ReviewerinPredicate
extends OperatorPredicate<ChangeData> {
    private final Provider<ReviewDb> dbProvider;
    private final IdentifiedUser.GenericFactory userFactory;
    private final AccountGroup.UUID uuid;

    ReviewerinPredicate(Provider<ReviewDb> dbProvider, IdentifiedUser.GenericFactory userFactory, AccountGroup.UUID uuid) {
        super("reviewerin", uuid.toString());
        this.dbProvider = dbProvider;
        this.userFactory = userFactory;
        this.uuid = uuid;
    }

    AccountGroup.UUID getAccountGroupUUID() {
        return this.uuid;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        for (Account.Id accountId : object.reviewers().values()) {
            IdentifiedUser reviewer = this.userFactory.create(this.dbProvider, accountId);
            if (!reviewer.getEffectiveGroups().contains(this.uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 3;
    }
}

