/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;

class TopicPredicate
extends IndexPredicate<ChangeData> {
    static FieldDef<ChangeData, ?> topicField(Schema<ChangeData> schema) {
        if (schema == null) {
            return ChangeField.LEGACY_TOPIC;
        }
        FieldDef<ChangeData, ?> f = schema.getFields().get(ChangeField.TOPIC.getName());
        if (f != null) {
            return f;
        }
        return schema.getFields().get(ChangeField.LEGACY_TOPIC.getName());
    }

    TopicPredicate(Schema<ChangeData> schema, String topic) {
        super(TopicPredicate.topicField(schema), topic);
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        if (change == null) {
            return false;
        }
        String t = change.getTopic();
        if (t == null && this.getField() == ChangeField.TOPIC) {
            t = "";
        }
        return this.getValue().equals(t);
    }

    @Override
    public int getCost() {
        return 1;
    }
}

