/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.Version;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class AllUsersCreator {
    private final GitRepositoryManager mgr;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;

    @Inject
    AllUsersCreator(GitRepositoryManager mgr, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverUser) {
        this.mgr = mgr;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException, ConfigInvalidException {
        try (Repository git = null;){
            git = this.mgr.openRepository(this.allUsersName);
            this.initAllUsers(git);
        }
    }

    private void initAllUsers(Repository git) throws IOException, ConfigInvalidException {
        MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git);
        md.getCommitBuilder().setAuthor(this.serverUser);
        md.getCommitBuilder().setCommitter(this.serverUser);
        md.setMessage("Initialized Gerrit Code Review " + Version.getVersion());
        ProjectConfig config = ProjectConfig.read(md);
        Project project = config.getProject();
        project.setDescription("Individual user settings and preferences.");
        AccessSection all = config.getAccessSection("refs/users/*", true);
        all.getPermission("read", true).setExclusiveGroup(true);
        config.commit(md);
    }
}

