/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.Current;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;

public class SchemaVersionCheck
implements LifecycleListener {
    private final SchemaFactory<ReviewDb> schema;
    private final SitePaths site;
    @Current
    private final Provider<SchemaVersion> version;

    public static Module module() {
        return new LifecycleModule(){

            @Override
            protected void configure() {
                this.listener().to(SchemaVersionCheck.class);
            }
        };
    }

    @Inject
    public SchemaVersionCheck(SchemaFactory<ReviewDb> schemaFactory, SitePaths site, @Current Provider<SchemaVersion> version) {
        this.schema = schemaFactory;
        this.site = site;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try (ReviewDb db = this.schema.open();){
            CurrentSchemaVersion currentVer = this.getSchemaVersion(db);
            int expectedVer = this.version.get().getVersionNbr();
            if (currentVer == null) {
                throw new ProvisionException("Schema not yet initialized.  Run init to initialize the schema:\n$ java -jar gerrit.war init -d " + this.site.site_path.getAbsolutePath());
            }
            if (currentVer.versionNbr < expectedVer) {
                throw new ProvisionException("Unsupported schema version " + currentVer.versionNbr + "; expected schema version " + expectedVer + ".  Run init to upgrade:\n" + "$ java -jar " + this.site.gerrit_war.getAbsolutePath() + " init -d " + this.site.site_path.getAbsolutePath());
            }
            if (currentVer.versionNbr > expectedVer) {
                throw new ProvisionException("Unsupported schema version " + currentVer.versionNbr + "; expected schema version " + expectedVer + ". Downgrade is not supported.");
            }
        }
        catch (OrmException e) {
            throw new ProvisionException("Cannot read schema_version", e);
        }
    }

    @Override
    public void stop() {
    }

    private CurrentSchemaVersion getSchemaVersion(ReviewDb db) {
        try {
            return db.schemaVersion().get(new CurrentSchemaVersion.Key());
        }
        catch (OrmException e) {
            return null;
        }
    }
}

