/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.CharMatcher;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

class ScriptRunner {
    private final String name;
    private final List<String> commands;
    static final ScriptRunner NOOP = new ScriptRunner(null, null){

        @Override
        void run(ReviewDb db) {
        }
    };

    ScriptRunner(String scriptName, InputStream script) {
        this.name = scriptName;
        try {
            this.commands = script != null ? this.parse(script) : null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse " + this.name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void run(ReviewDb db) throws OrmException {
        try {
            JdbcSchema schema = (JdbcSchema)((Object)db);
            Connection c = schema.getConnection();
            SqlDialect dialect = schema.getDialect();
            try (Statement stmt = c.createStatement();){
                for (String sql : this.commands) {
                    try {
                        if (!dialect.isStatementDelimiterSupported()) {
                            sql = CharMatcher.is(';').trimTrailingFrom(sql);
                        }
                        stmt.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new OrmException("Error in " + this.name + ":\n" + sql, e);
                        return;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OrmException("Cannot run statements for " + this.name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parse(InputStream in) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line;
            String delimiter = ";";
            ArrayList<String> commands = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("--")) continue;
                if (buffer.length() == 0 && line.toLowerCase().startsWith("delimiter ")) {
                    delimiter = line.substring("delimiter ".length()).trim();
                    continue;
                }
                if (buffer.length() > 0) {
                    buffer.append('\n');
                }
                buffer.append(line);
                if (!this.isDone(delimiter, line, buffer)) continue;
                String cmd = buffer.toString();
                commands.add(cmd);
                buffer = new StringBuilder();
            }
            if (buffer.length() > 0) {
                commands.add(buffer.toString());
            }
            ArrayList<String> arrayList = commands;
            return arrayList;
        }
    }

    private boolean isDone(String delimiter, String line, StringBuilder buffer) {
        if (";".equals(delimiter)) {
            return buffer.charAt(buffer.length() - 1) == ';';
        }
        if (line.equals(delimiter)) {
            buffer.setLength(buffer.length() - delimiter.length());
            return true;
        }
        return false;
    }
}

