/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.ssh;

import com.google.common.collect.Lists;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.ssh.SshAdvertisedAddresses;
import com.google.gerrit.server.ssh.SshListenAddresses;
import com.google.gerrit.server.util.SocketUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAddressesModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(SshAddressesModule.class);
    public static final int DEFAULT_PORT = 29418;
    public static final int IANA_SSH_PORT = 22;

    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @SshListenAddresses
    public List<SocketAddress> getListenAddresses(@GerritServerConfig Config cfg) {
        ArrayList<SocketAddress> listen = Lists.newArrayListWithExpectedSize(2);
        String[] want = cfg.getStringList("sshd", null, "listenaddress");
        if (want == null || want.length == 0) {
            listen.add(new InetSocketAddress(29418));
            return listen;
        }
        if (want.length == 1 && SshAddressesModule.isOff(want[0])) {
            return listen;
        }
        for (String desc : want) {
            try {
                listen.add(SocketUtil.resolve(desc, 29418));
            }
            catch (IllegalArgumentException e) {
                log.error("Bad sshd.listenaddress: " + desc + ": " + e.getMessage());
            }
        }
        return listen;
    }

    private static boolean isOff(String listenHostname) {
        return "off".equalsIgnoreCase(listenHostname) || "none".equalsIgnoreCase(listenHostname) || "no".equalsIgnoreCase(listenHostname);
    }

    @Provides
    @Singleton
    @SshAdvertisedAddresses
    List<String> getAdvertisedAddresses(@GerritServerConfig Config cfg, @SshListenAddresses List<SocketAddress> listen) {
        String[] want = cfg.getStringList("sshd", null, "advertisedaddress");
        if (want.length > 0) {
            return Arrays.asList(want);
        }
        ArrayList<InetSocketAddress> pub = Lists.newArrayList();
        ArrayList<InetSocketAddress> local = Lists.newArrayList();
        for (SocketAddress addr : listen) {
            if (!(addr instanceof InetSocketAddress)) continue;
            InetSocketAddress inetAddr = (InetSocketAddress)addr;
            if (inetAddr.getAddress().isLoopbackAddress()) {
                local.add(inetAddr);
                continue;
            }
            pub.add(inetAddr);
        }
        if (pub.isEmpty()) {
            pub = local;
        }
        ArrayList<String> adv = Lists.newArrayListWithCapacity(pub.size());
        for (InetSocketAddress addr : pub) {
            adv.add(SocketUtil.format(addr, 22));
        }
        return adv;
    }
}

