/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.primitives.Ints;
import com.google.gerrit.common.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RangeUtil {
    private static final Pattern RANGE_PATTERN = Pattern.compile("(>|>=|=|<|<=|)([+-]?\\d+)$");

    private RangeUtil() {
    }

    @Nullable
    public static Range getRange(String rangeQuery, int minValue, int maxValue) {
        Integer queryInt;
        String test;
        String prefix;
        Matcher m = RANGE_PATTERN.matcher(rangeQuery);
        if (m.find()) {
            prefix = rangeQuery.substring(0, m.start());
            test = m.group(1);
            queryInt = RangeUtil.value(m.group(2));
            if (queryInt == null) {
                return null;
            }
        } else {
            return null;
        }
        return RangeUtil.getRange(prefix, test, queryInt, minValue, maxValue);
    }

    public static Range getRange(String prefix, String test, int queryInt, int minValue, int maxValue) {
        int min;
        int max;
        switch (test) {
            default: {
                min = max = queryInt;
                break;
            }
            case ">": {
                min = Ints.saturatedCast((long)queryInt + 1L);
                max = maxValue;
                break;
            }
            case ">=": {
                min = queryInt;
                max = maxValue;
                break;
            }
            case "<": {
                min = minValue;
                max = Ints.saturatedCast((long)queryInt - 1L);
                break;
            }
            case "<=": {
                min = minValue;
                max = queryInt;
            }
        }
        return new Range(prefix, min, max);
    }

    private static Integer value(String value) {
        if (value.startsWith("+")) {
            value = value.substring(1);
        }
        return Ints.tryParse(value);
    }

    public static class Range {
        public final String prefix;
        public final int min;
        public final int max;

        public Range(String prefix, int min, int max) {
            this.prefix = prefix;
            this.min = min;
            this.max = max;
        }
    }
}

