/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public final class SocketUtil {
    public static boolean isIPv6(InetAddress ip) {
        return ip instanceof Inet6Address && ip.getHostName().equals(ip.getHostAddress());
    }

    public static String hostname(InetSocketAddress addr) {
        if (addr.getAddress() != null) {
            if (addr.getAddress().isAnyLocalAddress()) {
                return "*";
            }
            return addr.getAddress().getHostName();
        }
        return addr.getHostName();
    }

    public static String format(SocketAddress s, int defaultPort) {
        if (s instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)s;
            if (addr.getPort() == defaultPort) {
                return SocketUtil.safeHostname(SocketUtil.hostname(addr));
            }
            return SocketUtil.format(SocketUtil.hostname(addr), addr.getPort());
        }
        return s.toString();
    }

    public static String format(String hostname, int port) {
        return SocketUtil.safeHostname(hostname) + ":" + port;
    }

    private static String safeHostname(String hostname) {
        if (0 <= hostname.indexOf(58)) {
            hostname = "[" + hostname + "]";
        }
        return hostname;
    }

    public static InetSocketAddress parse(String desc, int defaultPort) {
        int port;
        String portStr;
        String hostStr;
        int hostEnd;
        if (desc.startsWith("[")) {
            hostEnd = desc.indexOf(93);
            if (hostEnd < 0) {
                throw new IllegalArgumentException("invalid IPv6: " + desc);
            }
            hostStr = desc.substring(1, hostEnd);
            portStr = desc.substring(hostEnd + 1);
        } else {
            hostEnd = desc.indexOf(58);
            hostStr = 0 <= hostEnd ? desc.substring(0, hostEnd) : desc;
            String string = portStr = 0 <= hostEnd ? desc.substring(hostEnd) : "";
        }
        if ("".equals(hostStr)) {
            hostStr = "*";
        }
        if (portStr.startsWith(":")) {
            portStr = portStr.substring(1);
        }
        if (portStr.length() > 0) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid port: " + desc);
            }
        } else {
            port = defaultPort;
        }
        if ("*".equals(hostStr)) {
            return new InetSocketAddress(port);
        }
        return InetSocketAddress.createUnresolved(hostStr, port);
    }

    public static InetSocketAddress resolve(String desc, int defaultPort) {
        InetSocketAddress addr = SocketUtil.parse(desc, defaultPort);
        if (addr.getAddress() != null && addr.getAddress().isAnyLocalAddress()) {
            return addr;
        }
        try {
            InetAddress host = InetAddress.getByName(addr.getHostName());
            return new InetSocketAddress(host, addr.getPort());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unknown host: " + desc, e);
        }
    }

    private SocketUtil() {
    }
}

