/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.base.Strings;
import com.google.gerrit.common.Die;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemLog {
    private static final Logger log = LoggerFactory.getLogger(SystemLog.class);
    private static final String LOG4J_CONFIGURATION = "log4j.configuration";
    private final SitePaths site;
    private final Config config;

    @Inject
    public SystemLog(SitePaths site, @GerritServerConfig Config config) {
        this.site = site;
        this.config = config;
    }

    public static boolean shouldConfigure() {
        return Strings.isNullOrEmpty(System.getProperty(LOG4J_CONFIGURATION));
    }

    public static Appender createAppender(File logdir, String name, Layout layout) {
        DailyRollingFileAppender dst = new DailyRollingFileAppender();
        dst.setName(name);
        dst.setLayout(layout);
        dst.setEncoding("UTF-8");
        dst.setFile(new File(SystemLog.resolve(logdir), name).getPath());
        dst.setImmediateFlush(true);
        dst.setAppend(true);
        dst.setErrorHandler(new DieErrorHandler());
        dst.activateOptions();
        dst.setErrorHandler(new OnlyOnceErrorHandler());
        return dst;
    }

    public AsyncAppender createAsyncAppender(String name, Layout layout) {
        AsyncAppender async = new AsyncAppender();
        async.setBlocking(true);
        async.setBufferSize(this.config.getInt("core", "asyncLoggingBufferSize", 64));
        async.setLocationInfo(false);
        if (SystemLog.shouldConfigure()) {
            async.addAppender(SystemLog.createAppender(this.site.logs_dir, name, layout));
        } else {
            Appender appender = LogManager.getLogger(name).getAppender(name);
            if (appender != null) {
                async.addAppender(appender);
            } else {
                log.warn("No appender with the name: " + name + " was found. " + name + " logging is disabled");
            }
        }
        async.activateOptions();
        return async;
    }

    private static File resolve(File logs_dir) {
        try {
            return logs_dir.getCanonicalFile();
        }
        catch (IOException e) {
            return logs_dir.getAbsoluteFile();
        }
    }

    private static final class DieErrorHandler
    implements ErrorHandler {
        private DieErrorHandler() {
        }

        @Override
        public void error(String message, Exception e, int errorCode, LoggingEvent event) {
            this.error(e != null ? e.getMessage() : message);
        }

        @Override
        public void error(String message, Exception e, int errorCode) {
            this.error(e != null ? e.getMessage() : message);
        }

        @Override
        public void error(String message) {
            throw new Die("Cannot open log file: " + message);
        }

        @Override
        public void activateOptions() {
        }

        @Override
        public void setAppender(Appender appender) {
        }

        @Override
        public void setBackupAppender(Appender appender) {
        }

        @Override
        public void setLogger(org.apache.log4j.Logger logger) {
        }
    }
}

