/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import java.io.PrintWriter;
import java.util.SortedSet;

public class TreeFormatter {
    public static final String NOT_VISIBLE_NODE = "(x)";
    private static final String NODE_PREFIX = "|-- ";
    private static final String LAST_NODE_PREFIX = "`-- ";
    private static final String DEFAULT_TAB_SEPARATOR = "|";
    private final PrintWriter stdout;
    private String currentTabSeparator = " ";

    public TreeFormatter(PrintWriter stdout) {
        this.stdout = stdout;
    }

    public void printTree(SortedSet<? extends TreeNode> rootNodes) {
        if (rootNodes.isEmpty()) {
            return;
        }
        if (rootNodes.size() == 1) {
            this.printTree(rootNodes.first());
        } else {
            this.currentTabSeparator = DEFAULT_TAB_SEPARATOR;
            int i = 0;
            int size = rootNodes.size();
            for (TreeNode treeNode : rootNodes) {
                boolean isLastRoot;
                boolean bl = isLastRoot = ++i == size;
                if (isLastRoot) {
                    this.currentTabSeparator = " ";
                }
                this.printTree(treeNode);
            }
        }
    }

    public void printTree(TreeNode rootNode) {
        this.printTree(rootNode, 0, true);
    }

    private void printTree(TreeNode node, int level, boolean isLast) {
        this.printNode(node, level, isLast);
        SortedSet<? extends TreeNode> childNodes = node.getChildren();
        int i = 0;
        int size = childNodes.size();
        for (TreeNode treeNode : childNodes) {
            boolean isLastChild = ++i == size;
            this.printTree(treeNode, level + 1, isLastChild);
        }
    }

    private void printIndention(int level) {
        if (level > 0) {
            this.stdout.print(String.format("%-" + 4 * level + "s", this.currentTabSeparator));
        }
    }

    private void printNode(TreeNode node, int level, boolean isLast) {
        this.printIndention(level);
        this.stdout.print(isLast ? LAST_NODE_PREFIX : NODE_PREFIX);
        if (node.isVisible()) {
            this.stdout.print(node.getDisplayName());
        } else {
            this.stdout.print(NOT_VISIBLE_NODE);
        }
        this.stdout.print("\n");
    }

    public static interface TreeNode {
        public String getDisplayName();

        public boolean isVisible();

        public SortedSet<? extends TreeNode> getChildren();
    }
}

