/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.inject.binder.LinkedBindingBuilder;
import org.apache.sshd.server.Command;

public abstract class CommandModule
extends LifecycleModule {
    protected boolean slaveMode;

    protected LinkedBindingBuilder<Command> command(String name) {
        return this.bind(Commands.key(name));
    }

    protected LinkedBindingBuilder<Command> command(CommandName name) {
        return this.bind(Commands.key(name));
    }

    protected LinkedBindingBuilder<Command> command(CommandName parent, String name) {
        return this.bind(Commands.key(parent, name));
    }

    protected void command(CommandName parent, Class<? extends BaseCommand> clazz) {
        CommandMetaData meta = clazz.getAnnotation(CommandMetaData.class);
        if (meta == null) {
            throw new IllegalStateException("no CommandMetaData annotation found");
        }
        if (meta.runsAt().isSupported(this.slaveMode)) {
            this.bind(Commands.key(parent, meta.name(), meta.description())).to(clazz);
        }
    }

    protected void alias(CommandName parent, String name, Class<? extends BaseCommand> clazz) {
        CommandMetaData meta = clazz.getAnnotation(CommandMetaData.class);
        if (meta == null) {
            throw new IllegalStateException("no CommandMetaData annotation found");
        }
        this.bind(Commands.key(parent, name, meta.description())).to(clazz);
    }

    protected void alias(String from, String to) {
        this.bind(Commands.key(from)).to(Commands.key(to));
    }
}

