/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.gerrit.sshd.SshUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;

@Singleton
class GerritGSSAuthenticator
extends GSSAuthenticator {
    private final AccountCache accounts;
    private final SshScope sshScope;
    private final SshLog sshLog;
    private final IdentifiedUser.GenericFactory userFactory;

    @Inject
    GerritGSSAuthenticator(AccountCache accounts, SshScope sshScope, SshLog sshLog, IdentifiedUser.GenericFactory userFactory) {
        this.accounts = accounts;
        this.sshScope = sshScope;
        this.sshLog = sshLog;
        this.userFactory = userFactory;
    }

    @Override
    public boolean validateIdentity(ServerSession session, String identity) {
        boolean active;
        SshSession sd = session.getAttribute(SshSession.KEY);
        int at = identity.indexOf(64);
        String username = at == -1 ? identity : identity.substring(0, at);
        AccountState state = this.accounts.getByUsername(username);
        Account account = state == null ? null : state.getAccount();
        boolean bl = active = account != null && account.isActive();
        if (active) {
            return SshUtil.success(username, session, this.sshScope, this.sshLog, sd, SshUtil.createUser(sd, this.userFactory, account.getId()));
        }
        return false;
    }
}

