/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.SystemReader;

class NoShell
implements Factory<Command> {
    private final Provider<SendMessage> shell;

    @Inject
    NoShell(Provider<SendMessage> shell) {
        this.shell = shell;
    }

    @Override
    public Command create() {
        return this.shell.get();
    }

    static class MessageFactory {
        private final IdentifiedUser user;
        private final SshInfo sshInfo;
        private final Provider<String> urlProvider;

        @Inject
        MessageFactory(IdentifiedUser user, SshInfo sshInfo, @CanonicalWebUrl Provider<String> urlProvider) {
            this.user = user;
            this.sshInfo = sshInfo;
            this.urlProvider = urlProvider;
        }

        String getMessage() {
            StringBuilder msg = new StringBuilder();
            msg.append("\r\n");
            msg.append("  ****    Welcome to Gerrit Code Review    ****\r\n");
            msg.append("\r\n");
            Account account = this.user.getAccount();
            String name = account.getFullName();
            if (name == null || name.isEmpty()) {
                name = this.user.getUserName();
            }
            msg.append("  Hi ");
            msg.append(name);
            msg.append(", you have successfully connected over SSH.");
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append("  Unfortunately, interactive shells are disabled.\r\n");
            msg.append("  To clone a hosted Git repository, use:\r\n");
            msg.append("\r\n");
            if (!this.sshInfo.getHostKeys().isEmpty()) {
                String host = this.sshInfo.getHostKeys().get(0).getHost();
                if (host.startsWith("*:")) {
                    host = this.getGerritHost() + host.substring(1);
                }
                msg.append("  git clone ssh://");
                msg.append(this.user.getUserName());
                msg.append("@");
                msg.append(host);
                msg.append("/");
                msg.append("REPOSITORY_NAME.git");
                msg.append("\r\n");
            }
            msg.append("\r\n");
            return msg.toString();
        }

        private String getGerritHost() {
            String url = this.urlProvider.get();
            if (url != null) {
                try {
                    return new URL(url).getHost();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return SystemReader.getInstance().getHostname();
        }
    }

    static class SendMessage
    implements Command,
    SessionAware {
        private final Provider<MessageFactory> messageFactory;
        private final SchemaFactory<ReviewDb> schemaFactory;
        private final SshScope sshScope;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback exit;
        private SshScope.Context context;

        @Inject
        SendMessage(Provider<MessageFactory> messageFactory, SchemaFactory<ReviewDb> sf, SshScope sshScope) {
            this.messageFactory = messageFactory;
            this.schemaFactory = sf;
            this.sshScope = sshScope;
        }

        @Override
        public void setInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        @Override
        public void setExitCallback(ExitCallback callback) {
            this.exit = callback;
        }

        @Override
        public void setSession(ServerSession session) {
            SshSession s = session.getAttribute(SshSession.KEY);
            this.context = this.sshScope.newContext(this.schemaFactory, s, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start(Environment env) throws IOException {
            String message;
            SshScope.Context old = this.sshScope.set(this.context);
            try {
                message = this.messageFactory.get().getMessage();
            }
            finally {
                this.sshScope.set(old);
            }
            this.err.write(Constants.encode(message));
            this.err.flush();
            this.in.close();
            this.out.close();
            this.err.close();
            this.exit.onExit(127);
        }

        @Override
        public void destroy() {
        }
    }
}

