/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.RequestCleanup;
import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestScopePropagator;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.sshd.SshSession;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import java.util.Map;

public class SshScope {
    private static final Key<RequestCleanup> RC_KEY = Key.get(RequestCleanup.class);
    private static final Key<RequestScopedReviewDbProvider> DB_KEY = Key.get(RequestScopedReviewDbProvider.class);
    private static final ThreadLocal<Context> current = new ThreadLocal();
    private final ThreadLocalRequestContext local;
    private final IdentifiedUser.RequestFactory userFactory;
    public static final Scope REQUEST = new Scope(){

        @Override
        public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){

                @Override
                public T get() {
                    return SshScope.requireContext().get(key, creator);
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        @Override
        public String toString() {
            return "SshScopes.REQUEST";
        }
    };

    private static Context requireContext() {
        Context ctx = current.get();
        if (ctx == null) {
            throw new OutOfScopeException("Not in command/request");
        }
        return ctx;
    }

    @Inject
    SshScope(ThreadLocalRequestContext local, IdentifiedUser.RequestFactory userFactory) {
        this.local = local;
        this.userFactory = userFactory;
    }

    Context newContext(SchemaFactory<ReviewDb> sf, SshSession s, String cmd) {
        return new Context(sf, s, cmd, TimeUtil.nowMs());
    }

    private Context newContinuingContext(Context ctx) {
        return new Context(ctx, ctx.getSession(), ctx.getCommandLine());
    }

    Context set(Context ctx) {
        Context old = current.get();
        current.set(ctx);
        this.local.setContext(ctx);
        return old;
    }

    static class Propagator
    extends ThreadLocalRequestScopePropagator<Context> {
        private final SshScope sshScope;

        @Inject
        Propagator(SshScope sshScope, ThreadLocalRequestContext local, Provider<RequestScopedReviewDbProvider> dbProviderProvider) {
            super(REQUEST, current, local, dbProviderProvider);
            this.sshScope = sshScope;
        }

        @Override
        protected Context continuingContext(Context ctx) {
            return this.sshScope.newContinuingContext(ctx);
        }
    }

    public static class SshSessionProvider
    implements Provider<SshSession> {
        @Override
        public SshSession get() {
            return SshScope.requireContext().getSession();
        }
    }

    static class ContextProvider
    implements Provider<Context> {
        ContextProvider() {
        }

        @Override
        public Context get() {
            return SshScope.requireContext();
        }
    }

    class Context
    implements RequestContext {
        private final RequestCleanup cleanup = new RequestCleanup();
        private final Map<Key<?>, Object> map = Maps.newHashMap();
        private final SchemaFactory<ReviewDb> schemaFactory;
        private final SshSession session;
        private final String commandLine;
        final long created;
        volatile long started;
        volatile long finished;

        private Context(SchemaFactory<ReviewDb> sf, SshSession s, String c, long at) {
            this.schemaFactory = sf;
            this.session = s;
            this.commandLine = c;
            this.started = this.finished = at;
            this.created = this.finished;
            this.map.put(RC_KEY, this.cleanup);
            this.map.put(DB_KEY, new RequestScopedReviewDbProvider(this.schemaFactory, Providers.of(this.cleanup)));
        }

        private Context(Context p, SshSession s, String c) {
            this(p.schemaFactory, s, c, p.created);
            this.started = p.started;
            this.finished = p.finished;
        }

        String getCommandLine() {
            return this.commandLine;
        }

        SshSession getSession() {
            return this.session;
        }

        @Override
        public CurrentUser getCurrentUser() {
            CurrentUser user = this.session.getCurrentUser();
            if (user != null && user.isIdentifiedUser()) {
                IdentifiedUser identifiedUser = SshScope.this.userFactory.create(((IdentifiedUser)user).getAccountId());
                identifiedUser.setAccessPath(user.getAccessPath());
                return identifiedUser;
            }
            return user;
        }

        @Override
        public Provider<ReviewDb> getReviewDbProvider() {
            return (RequestScopedReviewDbProvider)this.map.get(DB_KEY);
        }

        synchronized <T> T get(Key<T> key, Provider<T> creator) {
            Object t = this.map.get(key);
            if (t == null) {
                t = creator.get();
                this.map.put(key, t);
            }
            return (T)t;
        }

        synchronized Context subContext(SshSession newSession, String newCommandLine) {
            Context ctx = new Context(this, newSession, newCommandLine);
            this.cleanup.add(ctx.cleanup);
            return ctx;
        }
    }
}

