/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jgit.lib.Config;

class StreamCommandExecutorProvider
implements Provider<WorkQueue.Executor> {
    private final int poolSize;
    private final WorkQueue queues;

    @Inject
    StreamCommandExecutorProvider(@GerritServerConfig Config config, WorkQueue wq) {
        int cores = Runtime.getRuntime().availableProcessors();
        this.poolSize = config.getInt("sshd", "streamThreads", cores + 1);
        this.queues = wq;
    }

    @Override
    public WorkQueue.Executor get() {
        WorkQueue.Executor executor = this.queues.createQueue(this.poolSize, "SSH-Stream-Worker");
        final ThreadFactory parent = executor.getThreadFactory();
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread t = parent.newThread(task);
                t.setPriority(1);
                return t;
            }
        });
        return executor;
    }
}

