/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.documentation.QueryDocumentationExecutor;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.List;
import org.kohsuke.args4j.Argument;

@CommandMetaData(name="apropos", description="Search in Gerrit documentation", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class AproposCommand
extends SshCommand {
    @Inject
    private QueryDocumentationExecutor searcher;
    @Inject
    @CanonicalWebUrl
    String url;
    @Argument(index=0, required=true, metaVar="QUERY")
    private String q;

    AproposCommand() {
    }

    @Override
    public void run() throws Exception {
        try {
            List<QueryDocumentationExecutor.DocResult> res = this.searcher.doQuery(this.q);
            for (QueryDocumentationExecutor.DocResult docResult : res) {
                this.stdout.println(String.format("%s:\n%s%s\n", docResult.title, this.url, docResult.url));
            }
        }
        catch (QueryDocumentationExecutor.DocQueryException dqe) {
            throw new BaseCommand.UnloggedFailure(1, "fatal: " + dqe.getMessage());
        }
    }
}

