/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.CreateAccount;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="createAccount")
@CommandMetaData(name="create-account", description="Create a new batch/role account")
final class CreateAccountCommand
extends SshCommand {
    @Option(name="--group", aliases={"-g"}, metaVar="GROUP", usage="groups to add account to")
    private List<AccountGroup.Id> groups = new ArrayList<AccountGroup.Id>();
    @Option(name="--full-name", metaVar="NAME", usage="display name of the account")
    private String fullName;
    @Option(name="--email", metaVar="EMAIL", usage="email address of the account")
    private String email;
    @Option(name="--ssh-key", metaVar="-|KEY", usage="public key for SSH authentication")
    private String sshKey;
    @Option(name="--http-password", metaVar="PASSWORD", usage="password for HTTP authentication")
    private String httpPassword;
    @Argument(index=0, required=true, metaVar="USERNAME", usage="name of the user account")
    private String username;
    @Inject
    private CreateAccount.Factory createAccountFactory;

    CreateAccountCommand() {
    }

    @Override
    protected void run() throws OrmException, IOException, BaseCommand.UnloggedFailure {
        CreateAccount.Input input = new CreateAccount.Input();
        input.username = this.username;
        input.email = this.email;
        input.name = this.fullName;
        input.sshKey = this.readSshKey();
        input.httpPassword = this.httpPassword;
        input.groups = Lists.transform(this.groups, new Function<AccountGroup.Id, String>(){

            @Override
            public String apply(AccountGroup.Id id) {
                return id.toString();
            }
        });
        try {
            this.createAccountFactory.create(this.username).apply(TopLevelResource.INSTANCE, input);
        }
        catch (RestApiException e) {
            throw this.die(e.getMessage());
        }
    }

    private String readSshKey() throws UnsupportedEncodingException, IOException {
        if (this.sshKey == null) {
            return null;
        }
        if ("-".equals(this.sshKey)) {
            String line;
            this.sshKey = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in, "UTF-8"));
            while ((line = br.readLine()) != null) {
                this.sshKey = this.sshKey + line + "\n";
            }
        }
        return this.sshKey;
    }
}

