/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GetGroups;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.ListGroups;
import com.google.gerrit.server.ioutil.ColumnFormatter;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.PrintWriter;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="ls-groups", description="List groups visible to the caller", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class ListGroupsCommand
extends BaseCommand {
    @Inject
    private MyListGroups impl;

    @Override
    public void start(Environment env) {
        this.startThread(new BaseCommand.CommandRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                ListGroupsCommand.this.parseCommandLine(ListGroupsCommand.this.impl);
                if (ListGroupsCommand.this.impl.getUser() != null && !ListGroupsCommand.this.impl.getProjects().isEmpty()) {
                    throw new BaseCommand.UnloggedFailure(1, "fatal: --user and --project options are not compatible.");
                }
                PrintWriter stdout = ListGroupsCommand.toPrintWriter(ListGroupsCommand.this.out);
                try {
                    ListGroupsCommand.this.impl.display(stdout);
                }
                finally {
                    stdout.flush();
                }
            }
        });
    }

    private static class MyListGroups
    extends ListGroups {
        @Option(name="--verbose", aliases={"-v"}, usage="verbose output format with tab-separated columns for the group name, UUID, description, owner group name, owner group UUID, and whether the group is visible to all")
        private boolean verboseOutput;

        @Inject
        MyListGroups(GroupCache groupCache, GroupControl.Factory groupControlFactory, GroupControl.GenericFactory genericGroupControlFactory, Provider<IdentifiedUser> identifiedUser, IdentifiedUser.GenericFactory userFactory, Provider<GetGroups> accountGetGroups, GroupJson json) {
            super(groupCache, groupControlFactory, genericGroupControlFactory, identifiedUser, userFactory, accountGetGroups, json);
        }

        void display(PrintWriter out) throws OrmException {
            ColumnFormatter formatter = new ColumnFormatter(out, '\t');
            for (GroupJson.GroupInfo info : this.get()) {
                formatter.addColumn(Objects.firstNonNull(info.name, "n/a"));
                if (this.verboseOutput) {
                    AccountGroup o = info.ownerId != null ? this.groupCache.get(new AccountGroup.UUID(Url.decode(info.ownerId))) : null;
                    formatter.addColumn(Url.decode(info.id));
                    formatter.addColumn(Strings.nullToEmpty(info.description));
                    formatter.addColumn(o != null ? o.getName() : "n/a");
                    formatter.addColumn(o != null ? o.getGroupUUID().get() : "");
                    formatter.addColumn(Boolean.toString(Objects.firstNonNull(info.options.visibleToAll, Boolean.FALSE)));
                }
                formatter.nextLine();
            }
            formatter.finish();
        }
    }
}

