/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.server.project.ListProjects;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.inject.Inject;
import java.util.List;
import org.apache.sshd.server.Environment;

@CommandMetaData(name="ls-projects", description="List projects visible to the caller", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class ListProjectsCommand
extends BaseCommand {
    @Inject
    private ListProjects impl;

    ListProjectsCommand() {
    }

    @Override
    public void start(Environment env) {
        this.startThread(new BaseCommand.CommandRunnable(){

            @Override
            public void run() throws Exception {
                ListProjectsCommand.this.parseCommandLine(ListProjectsCommand.this.impl);
                if (!ListProjectsCommand.this.impl.getFormat().isJson()) {
                    List<String> showBranch = ListProjectsCommand.this.impl.getShowBranch();
                    if (ListProjectsCommand.this.impl.isShowTree() && showBranch != null && !showBranch.isEmpty()) {
                        throw new BaseCommand.UnloggedFailure(1, "fatal: --tree and --show-branch options are not compatible.");
                    }
                    if (ListProjectsCommand.this.impl.isShowTree() && ListProjectsCommand.this.impl.isShowDescription()) {
                        throw new BaseCommand.UnloggedFailure(1, "fatal: --tree and --description options are not compatible.");
                    }
                }
                ListProjectsCommand.this.impl.display(ListProjectsCommand.this.out);
            }
        });
    }
}

