/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.git.ChangeCache;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="ls-user-refs", description="List refs visible to a specific user", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class LsUserRefs
extends SshCommand {
    @Inject
    private AccountResolver accountResolver;
    @Inject
    private IdentifiedUser.GenericFactory userFactory;
    @Inject
    private ReviewDb db;
    @Inject
    private TagCache tagCache;
    @Inject
    private ChangeCache changeCache;
    @Option(name="--project", aliases={"-p"}, metaVar="PROJECT", required=true, usage="project for which the refs should be listed")
    private ProjectControl projectControl;
    @Option(name="--user", aliases={"-u"}, metaVar="USER", required=true, usage="user for which the groups should be listed")
    private String userName;
    @Option(name="--only-refs-heads", usage="list only refs under refs/heads")
    private boolean onlyRefsHeads;
    @Inject
    private GitRepositoryManager repoManager;

    @Override
    protected void run() throws BaseCommand.Failure {
        Repository repo;
        Account userAccount;
        try {
            userAccount = this.accountResolver.find(this.userName);
        }
        catch (OrmException e) {
            throw this.die(e);
        }
        if (userAccount == null) {
            this.stdout.print("No single user could be found when searching for: " + this.userName + '\n');
            this.stdout.flush();
            return;
        }
        IdentifiedUser user = this.userFactory.create(userAccount.getId());
        ProjectControl userProjectControl = this.projectControl.forUser(user);
        try {
            repo = this.repoManager.openRepository(userProjectControl.getProject().getNameKey());
        }
        catch (RepositoryNotFoundException e) {
            throw new BaseCommand.UnloggedFailure("fatal: '" + this.projectControl.getProject().getNameKey() + "': not a git archive");
        }
        catch (IOException e) {
            throw new BaseCommand.UnloggedFailure("fatal: Error opening: '" + this.projectControl.getProject().getNameKey());
        }
        try {
            Map<String, Ref> refsMap = new VisibleRefFilter(this.tagCache, this.changeCache, repo, userProjectControl, this.db, true).filter(repo.getRefDatabase().getRefs(""), false);
            for (String ref : refsMap.keySet()) {
                if (this.onlyRefsHeads && !ref.startsWith("refs/heads/")) continue;
                this.stdout.println(ref);
            }
        }
        catch (IOException e) {
            throw new BaseCommand.Failure(1, "fatal: Error reading refs: '" + this.projectControl.getProject().getNameKey(), e);
        }
        finally {
            repo.close();
        }
    }
}

