/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.Sets;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.List;
import org.kohsuke.args4j.Argument;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="remove", description="Disable plugins", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class PluginRemoveCommand
extends SshCommand {
    @Argument(index=0, metaVar="NAME", required=true, usage="plugin to remove")
    List<String> names;
    @Inject
    private PluginLoader loader;

    PluginRemoveCommand() {
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw this.die("remote plugin administration is disabled");
        }
        if (this.names != null && !this.names.isEmpty()) {
            this.loader.disablePlugins(Sets.newHashSet(this.names));
        }
    }
}

