/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.Version;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class QueryShell {
    private final BufferedReader in;
    private final PrintWriter out;
    private final SchemaFactory<ReviewDb> dbFactory;
    private OutputFormat outputFormat = OutputFormat.PRETTY;
    private ReviewDb db;
    private Connection connection;
    private Statement statement;

    @Inject
    QueryShell(SchemaFactory<ReviewDb> dbFactory, @Assisted InputStream in, @Assisted OutputStream out) throws UnsupportedEncodingException {
        this.dbFactory = dbFactory;
        this.in = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        this.out = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
    }

    public void setOutputFormat(OutputFormat fmt) {
        this.outputFormat = fmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.db = this.dbFactory.open();
            try {
                this.connection = ((JdbcSchema)((Object)this.db)).getConnection();
                this.connection.setAutoCommit(true);
                this.statement = this.connection.createStatement();
                try {
                    this.showBanner();
                    this.readEvalPrintLoop();
                }
                finally {
                    this.statement.close();
                    this.statement = null;
                }
            }
            finally {
                this.db.close();
                this.db = null;
            }
        }
        catch (OrmException err) {
            this.out.println("fatal: Cannot open connection: " + err.getMessage());
        }
        catch (SQLException err) {
            this.out.println("fatal: Cannot open connection: " + err.getMessage());
        }
        finally {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String query) {
        try {
            this.db = this.dbFactory.open();
            try {
                this.connection = ((JdbcSchema)((Object)this.db)).getConnection();
                this.connection.setAutoCommit(true);
                this.statement = this.connection.createStatement();
                try {
                    this.executeStatement(query);
                }
                finally {
                    this.statement.close();
                    this.statement = null;
                }
            }
            finally {
                this.db.close();
                this.db = null;
            }
        }
        catch (OrmException err) {
            this.out.println("fatal: Cannot open connection: " + err.getMessage());
        }
        catch (SQLException err) {
            this.out.println("fatal: Cannot open connection: " + err.getMessage());
        }
        finally {
            this.out.flush();
        }
    }

    private void readEvalPrintLoop() {
        StringBuilder buffer = new StringBuilder();
        boolean executed = false;
        block3: while (true) {
            String line;
            if (this.outputFormat == OutputFormat.PRETTY) {
                this.print(buffer.length() == 0 || executed ? "gerrit> " : "     -> ");
            }
            if ((line = this.readLine()) == null) {
                return;
            }
            if (line.startsWith("\\")) {
                if ((line = line.substring(1)).equals("h") || line.equals("?")) {
                    this.showHelp();
                    continue;
                }
                if (line.equals("q")) {
                    if (this.outputFormat == OutputFormat.PRETTY) {
                        this.println("Bye");
                    }
                    return;
                }
                if (line.equals("r")) {
                    buffer.setLength(0);
                    executed = false;
                    continue;
                }
                if (line.equals("p")) {
                    this.println(buffer.toString());
                    continue;
                }
                if (line.equals("g")) {
                    if (buffer.length() <= 0) continue;
                    this.executeStatement(buffer.toString());
                    executed = true;
                    continue;
                }
                if (line.equals("d")) {
                    this.listTables();
                    continue;
                }
                if (line.startsWith("d ")) {
                    this.showTable(line.substring(2).trim());
                    continue;
                }
                String msg = "'\\" + line + "' not supported";
                switch (this.outputFormat) {
                    case JSON_SINGLE: 
                    case JSON: {
                        JsonObject err = new JsonObject();
                        err.addProperty("type", "error");
                        err.addProperty("message", msg);
                        this.println(err.toString());
                        continue block3;
                    }
                }
                this.println("ERROR: " + msg);
                this.println("");
                this.showHelp();
                continue;
            }
            if (executed) {
                buffer.setLength(0);
                executed = false;
            }
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append(line);
            if (buffer.length() <= 0 || buffer.charAt(buffer.length() - 1) != ';') continue;
            this.executeStatement(buffer.toString());
            executed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listTables() {
        DatabaseMetaData meta;
        try {
            meta = this.connection.getMetaData();
        }
        catch (SQLException e) {
            this.error(e);
            return;
        }
        try {
            String[] types = new String[]{"TABLE", "VIEW"};
            try (ResultSet rs = meta.getTables(null, null, null, types);){
                if (this.outputFormat == OutputFormat.PRETTY) {
                    this.println("                     List of relations");
                }
                this.showResultSet(rs, false, 0L, Identity.create(rs, "TABLE_SCHEM"), Identity.create(rs, "TABLE_NAME"), Identity.create(rs, "TABLE_TYPE"));
            }
        }
        catch (SQLException e) {
            this.error(e);
        }
        this.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTable(String tableName) {
        ResultSet rs;
        DatabaseMetaData meta;
        try {
            meta = this.connection.getMetaData();
            if (meta.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (meta.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
        }
        catch (SQLException e) {
            this.error(e);
            return;
        }
        try {
            rs = meta.getColumns(null, null, tableName, null);
            try {
                if (!rs.next()) {
                    throw new SQLException("Table " + tableName + " not found");
                }
                if (this.outputFormat == OutputFormat.PRETTY) {
                    this.println("                     Table " + tableName);
                }
                this.showResultSet(rs, true, 0L, Identity.create(rs, "COLUMN_NAME"), new Function("TYPE"){

                    @Override
                    String apply(ResultSet rs) throws SQLException {
                        int nullable;
                        String type = rs.getString("TYPE_NAME");
                        switch (rs.getInt("DATA_TYPE")) {
                            case 1: 
                            case 12: {
                                type = type + "(" + rs.getInt("COLUMN_SIZE") + ")";
                            }
                        }
                        String def = rs.getString("COLUMN_DEF");
                        if (def != null && !def.isEmpty()) {
                            type = type + " DEFAULT " + def;
                        }
                        if ((nullable = rs.getInt("NULLABLE")) == 0) {
                            type = type + " NOT NULL";
                        }
                        return type;
                    }
                });
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            this.error(e);
            return;
        }
        try {
            rs = meta.getIndexInfo(null, null, tableName, false, true);
            try {
                TreeMap<String, IndexInfo> indexes = new TreeMap<String, IndexInfo>();
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    IndexInfo def = (IndexInfo)indexes.get(indexName);
                    if (def == null) {
                        def = new IndexInfo();
                        def.name = indexName;
                        indexes.put(indexName, def);
                    }
                    if (!rs.getBoolean("NON_UNIQUE")) {
                        def.unique = true;
                    }
                    int pos = rs.getInt("ORDINAL_POSITION");
                    String col = rs.getString("COLUMN_NAME");
                    String desc = rs.getString("ASC_OR_DESC");
                    desc = "D".equals(desc) ? " DESC" : "";
                    def.addColumn(pos, col + desc);
                    String filter = rs.getString("FILTER_CONDITION");
                    if (filter == null || filter.isEmpty()) continue;
                    def.filter.append(filter);
                }
                if (this.outputFormat == OutputFormat.PRETTY) {
                    this.println("");
                    this.println("Indexes on " + tableName + ":");
                    for (IndexInfo def : indexes.values()) {
                        this.println("  " + def);
                    }
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            this.error(e);
            return;
        }
        this.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(String sql) {
        block11: {
            boolean hasResultSet;
            long start = TimeUtil.nowMs();
            try {
                hasResultSet = this.statement.execute(sql);
            }
            catch (SQLException e) {
                this.error(e);
                return;
            }
            try {
                if (hasResultSet) {
                    try (ResultSet rs = this.statement.getResultSet();){
                        this.showResultSet(rs, false, start, new Function[0]);
                        break block11;
                    }
                }
                int updateCount = this.statement.getUpdateCount();
                long ms = TimeUtil.nowMs() - start;
                switch (this.outputFormat) {
                    case JSON_SINGLE: 
                    case JSON: {
                        JsonObject tail = new JsonObject();
                        tail.addProperty("type", "update-stats");
                        tail.addProperty("rowCount", updateCount);
                        tail.addProperty("runTimeMilliseconds", ms);
                        this.println(tail.toString());
                        break;
                    }
                    default: {
                        this.println("UPDATE " + updateCount + "; " + ms + " ms");
                    }
                }
            }
            catch (SQLException e) {
                this.error(e);
            }
        }
    }

    private void showResultSet(ResultSet rs, boolean alreadyOnRow, long start, Function ... show) throws SQLException {
        switch (this.outputFormat) {
            case JSON_SINGLE: 
            case JSON: {
                this.showResultSetJson(rs, alreadyOnRow, start, show);
                break;
            }
            default: {
                this.showResultSetPretty(rs, alreadyOnRow, start, show);
            }
        }
    }

    private void showResultSetJson(ResultSet rs, boolean alreadyOnRow, long start, Function ... show) throws SQLException {
        Function[] columnMap;
        JsonArray collector = new JsonArray();
        ResultSetMetaData meta = rs.getMetaData();
        if (show != null && 0 < show.length) {
            columnMap = show;
        } else {
            int colCnt = meta.getColumnCount();
            columnMap = new Function[colCnt];
            for (int colId = 0; colId < colCnt; ++colId) {
                int p = colId + 1;
                String name = meta.getColumnLabel(p);
                columnMap[colId] = new Identity(p, name);
            }
        }
        int rowCnt = 0;
        while (alreadyOnRow || rs.next()) {
            JsonObject row = new JsonObject();
            JsonObject cols = new JsonObject();
            for (Function function : columnMap) {
                String v = function.apply(rs);
                if (v == null) continue;
                cols.addProperty(function.name.toLowerCase(), v);
            }
            row.addProperty("type", "row");
            row.add("columns", cols);
            switch (this.outputFormat) {
                case JSON: {
                    this.println(row.toString());
                    break;
                }
                case JSON_SINGLE: {
                    collector.add(row);
                    break;
                }
                default: {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("type", "error");
                    obj.addProperty("message", "Unsupported Json variant");
                    this.println(obj.toString());
                    return;
                }
            }
            alreadyOnRow = false;
            ++rowCnt;
        }
        JsonObject tail = null;
        if (start != 0L) {
            tail = new JsonObject();
            tail.addProperty("type", "query-stats");
            tail.addProperty("rowCount", rowCnt);
            long ms = TimeUtil.nowMs() - start;
            tail.addProperty("runTimeMilliseconds", ms);
        }
        switch (this.outputFormat) {
            case JSON: {
                if (tail == null) break;
                this.println(tail.toString());
                break;
            }
            case JSON_SINGLE: {
                if (tail != null) {
                    collector.add(tail);
                }
                this.println(collector.toString());
                break;
            }
            default: {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", "error");
                obj.addProperty("message", "Unsupported Json variant");
                this.println(obj.toString());
            }
        }
    }

    private void showResultSetPretty(ResultSet rs, boolean alreadyOnRow, long start, Function ... show) throws SQLException {
        int c;
        int colCnt;
        Function[] columnMap;
        ResultSetMetaData meta = rs.getMetaData();
        if (show != null && 0 < show.length) {
            columnMap = show;
        } else {
            colCnt = meta.getColumnCount();
            columnMap = new Function[colCnt];
            for (int colId = 0; colId < colCnt; ++colId) {
                int p = colId + 1;
                String name = meta.getColumnLabel(p);
                columnMap[colId] = new Identity(p, name);
            }
        }
        colCnt = columnMap.length;
        int[] widths = new int[colCnt];
        for (int c2 = 0; c2 < colCnt; ++c2) {
            widths[c2] = columnMap[c2].name.length();
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        while (alreadyOnRow || rs.next()) {
            String[] row = new String[columnMap.length];
            for (c = 0; c < colCnt; ++c) {
                row[c] = columnMap[c].apply(rs);
                if (row[c] == null) {
                    row[c] = "NULL";
                }
                widths[c] = Math.max(widths[c], row[c].length());
            }
            rows.add(row);
            alreadyOnRow = false;
        }
        StringBuilder b = new StringBuilder();
        for (c = 0; c < colCnt; ++c) {
            String n;
            if (0 < c) {
                b.append(" | ");
            }
            if (widths[c] < (n = columnMap[c].name).length()) {
                n = n.substring(0, widths[c]);
            }
            b.append(n);
            if (c >= colCnt - 1) continue;
            for (int pad = n.length(); pad < widths[c]; ++pad) {
                b.append(' ');
            }
        }
        this.println(" " + b.toString());
        b.setLength(0);
        for (c = 0; c < colCnt; ++c) {
            if (0 < c) {
                b.append("-+-");
            }
            for (int pad = 0; pad < widths[c]; ++pad) {
                b.append('-');
            }
        }
        this.println(" " + b.toString());
        boolean dataTruncated = false;
        for (String[] row : rows) {
            b.setLength(0);
            b.append(' ');
            for (int c3 = 0; c3 < colCnt; ++c3) {
                int max = widths[c3];
                if (0 < c3) {
                    b.append(" | ");
                }
                String s = row[c3];
                if (1 < colCnt && max < s.length()) {
                    s = s.substring(0, max);
                    dataTruncated = true;
                }
                b.append(s);
                if (c3 >= colCnt - 1) continue;
                for (int pad = s.length(); pad < max; ++pad) {
                    b.append(' ');
                }
            }
            this.println(b.toString());
        }
        if (dataTruncated) {
            this.warning("some column data was truncated");
        }
        if (start != 0L) {
            int rowCount = rows.size();
            long ms = TimeUtil.nowMs() - start;
            this.println("(" + rowCount + (rowCount == 1 ? " row" : " rows") + "; " + ms + " ms)");
        }
    }

    private void warning(String msg) {
        switch (this.outputFormat) {
            case JSON_SINGLE: 
            case JSON: {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", "warning");
                obj.addProperty("message", msg);
                this.println(obj.toString());
                break;
            }
            default: {
                this.println("WARNING: " + msg);
            }
        }
    }

    private void error(SQLException err) {
        switch (this.outputFormat) {
            case JSON_SINGLE: 
            case JSON: {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", "error");
                obj.addProperty("message", err.getMessage());
                this.println(obj.toString());
                break;
            }
            default: {
                this.println("ERROR: " + err.getMessage());
            }
        }
    }

    private void print(String s) {
        this.out.print(s);
        this.out.flush();
    }

    private void println(String s) {
        this.out.print(s);
        this.out.print('\n');
        this.out.flush();
    }

    private String readLine() {
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void showBanner() {
        if (this.outputFormat == OutputFormat.PRETTY) {
            this.println("Welcome to Gerrit Code Review " + Version.getVersion());
            try {
                this.print("(");
                this.print(this.connection.getMetaData().getDatabaseProductName());
                this.print(" ");
                this.print(this.connection.getMetaData().getDatabaseProductVersion());
                this.println(")");
            }
            catch (SQLException err) {
                this.error(err);
            }
            this.println("");
            this.println("Type '\\h' for help.  Type '\\r' to clear the buffer.");
            this.println("");
        }
    }

    private void showHelp() {
        StringBuilder help = new StringBuilder();
        help.append("General\n");
        help.append("  \\q        quit\n");
        help.append("\n");
        help.append("Query Buffer\n");
        help.append("  \\g        execute the query buffer\n");
        help.append("  \\p        display the current buffer\n");
        help.append("  \\r        clear the query buffer\n");
        help.append("\n");
        help.append("Informational\n");
        help.append("  \\d        list all tables\n");
        help.append("  \\d NAME   describe table\n");
        help.append("\n");
        this.print(help.toString());
    }

    private static class IndexInfo {
        String name;
        boolean unique;
        final Map<Integer, String> columns = new TreeMap<Integer, String>();
        final StringBuilder filter = new StringBuilder();

        private IndexInfo() {
        }

        void addColumn(int pos, String column) {
            this.columns.put(pos, column);
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append(this.name);
            if (this.unique) {
                r.append(" UNIQUE");
            }
            r.append(" (");
            boolean first = true;
            for (String c : this.columns.values()) {
                if (!first) {
                    r.append(", ");
                }
                r.append(c);
                first = false;
            }
            r.append(")");
            if (this.filter.length() > 0) {
                r.append(" WHERE ");
                r.append((CharSequence)this.filter);
            }
            return r.toString();
        }
    }

    private static class Identity
    extends Function {
        final int colId;

        static Identity create(ResultSet rs, String name) throws SQLException {
            return new Identity(rs.findColumn(name), name);
        }

        Identity(int colId, String name) {
            super(name);
            this.colId = colId;
        }

        @Override
        String apply(ResultSet rs) throws SQLException {
            return rs.getString(this.colId);
        }
    }

    private static abstract class Function {
        final String name;

        Function(String name) {
            this.name = name;
        }

        abstract String apply(ResultSet var1) throws SQLException;
    }

    public static enum OutputFormat {
        PRETTY,
        JSON,
        JSON_SINGLE;

    }

    public static interface Factory {
        public QueryShell create(@Assisted InputStream var1, @Assisted OutputStream var2);
    }
}

