/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.Lists;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.AsyncReceiveCommits;
import com.google.gerrit.server.git.ReceiveCommits;
import com.google.gerrit.server.git.ReceivePackInitializer;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.sshd.AbstractGitCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PostReceiveHookChain;
import org.eclipse.jgit.transport.ReceivePack;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="receive-pack", description="Standard Git server side command for client side git push")
final class Receive
extends AbstractGitCommand {
    private static final Logger log = LoggerFactory.getLogger(Receive.class);
    @Inject
    private AsyncReceiveCommits.Factory factory;
    @Inject
    private IdentifiedUser currentUser;
    @Inject
    private IdentifiedUser.GenericFactory identifiedUserFactory;
    @Inject
    private TransferConfig config;
    @Inject
    private DynamicSet<ReceivePackInitializer> receivePackInitializers;
    @Inject
    private DynamicSet<PostReceiveHook> postReceiveHooks;
    private final Set<Account.Id> reviewerId = new HashSet<Account.Id>();
    private final Set<Account.Id> ccId = new HashSet<Account.Id>();

    Receive() {
    }

    @Option(name="--reviewer", aliases={"--re"}, metaVar="EMAIL", usage="request reviewer for change(s)")
    void addReviewer(Account.Id id) {
        this.reviewerId.add(id);
    }

    @Option(name="--cc", aliases={}, metaVar="EMAIL", usage="CC user on change(s)")
    void addCC(Account.Id id) {
        this.ccId.add(id);
    }

    @Override
    protected void runImpl() throws IOException, BaseCommand.Failure {
        if (!this.projectControl.canRunReceivePack()) {
            throw new BaseCommand.Failure(1, "fatal: receive-pack not permitted on this server");
        }
        ReceiveCommits receive = this.factory.create(this.projectControl, this.repo).getReceiveCommits();
        Capable r = receive.canUpload();
        if (r != Capable.OK) {
            throw new BaseCommand.UnloggedFailure(1, "\nfatal: " + r.getMessage());
        }
        this.verifyProjectVisible("reviewer", this.reviewerId);
        this.verifyProjectVisible("CC", this.ccId);
        receive.addReviewers(this.reviewerId);
        receive.addExtraCC(this.ccId);
        ReceivePack rp = receive.getReceivePack();
        rp.setRefLogIdent(this.currentUser.newRefLogIdent());
        rp.setTimeout(this.config.getTimeout());
        rp.setMaxObjectSizeLimit(this.config.getEffectiveMaxObjectSizeLimit(this.projectControl.getProjectState()));
        this.init(rp);
        rp.setPostReceiveHook(PostReceiveHookChain.newChain(Lists.newArrayList(this.postReceiveHooks)));
        try {
            rp.receive(this.in, this.out, this.err);
        }
        catch (UnpackException badStream) {
            if (badStream.getCause() instanceof TooLargeObjectInPackException) {
                StringBuilder msg = new StringBuilder();
                msg.append("Receive error on project \"").append(this.projectControl.getProject().getName()).append("\"");
                msg.append(" (user ");
                msg.append(this.currentUser.getAccount().getUserName());
                msg.append(" account ");
                msg.append(this.currentUser.getAccountId());
                msg.append("): ");
                msg.append(badStream.getCause().getMessage());
                log.info(msg.toString());
                throw new BaseCommand.UnloggedFailure(128, "error: " + badStream.getCause().getMessage());
            }
            StringBuilder msg = new StringBuilder();
            msg.append("Unpack error on project \"").append(this.projectControl.getProject().getName()).append("\":\n");
            msg.append("  AdvertiseRefsHook: ").append(rp.getAdvertiseRefsHook());
            if (rp.getAdvertiseRefsHook() == AdvertiseRefsHook.DEFAULT) {
                msg.append("DEFAULT");
            } else if (rp.getAdvertiseRefsHook() instanceof VisibleRefFilter) {
                msg.append("VisibleRefFilter");
            } else {
                msg.append(rp.getAdvertiseRefsHook().getClass());
            }
            msg.append("\n");
            if (rp.getAdvertiseRefsHook() instanceof VisibleRefFilter) {
                Map<String, Ref> adv = rp.getAdvertisedRefs();
                msg.append("  Visible references (").append(adv.size()).append("):\n");
                for (Ref ref : adv.values()) {
                    msg.append("  - ").append(ref.getObjectId().abbreviate(8).name()).append(" ").append(ref.getName()).append("\n");
                }
                Map<String, Ref> allRefs = rp.getRepository().getRefDatabase().getRefs("");
                ArrayList<Ref> hidden = new ArrayList<Ref>();
                for (Ref ref : allRefs.values()) {
                    if (adv.containsKey(ref.getName())) continue;
                    hidden.add(ref);
                }
                msg.append("  Hidden references (").append(hidden.size()).append("):\n");
                for (Ref ref : hidden) {
                    msg.append("  - ").append(ref.getObjectId().abbreviate(8).name()).append(" ").append(ref.getName()).append("\n");
                }
            }
            IOException detail = new IOException(msg.toString(), badStream);
            throw new BaseCommand.Failure(128, "fatal: Unpack error, check server log", detail);
        }
    }

    private void init(ReceivePack rp) {
        for (ReceivePackInitializer initializer : this.receivePackInitializers) {
            initializer.init(this.projectControl.getProject().getNameKey(), rp);
        }
    }

    private void verifyProjectVisible(String type, Set<Account.Id> who) throws BaseCommand.UnloggedFailure {
        for (Account.Id id : who) {
            IdentifiedUser user = this.identifiedUserFactory.create(id);
            if (this.projectControl.forUser(user).isVisible()) continue;
            throw new BaseCommand.UnloggedFailure(1, type + " " + user.getAccount().getFullName() + " cannot access the project");
        }
    }
}

