/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.server.account.PerformRenameGroup;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import org.kohsuke.args4j.Argument;

@CommandMetaData(name="rename-group", description="Rename an account group")
public class RenameGroupCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="GROUP", usage="name of the group to be renamed")
    private String groupName;
    @Argument(index=1, required=true, metaVar="NEWNAME", usage="new name of the group")
    private String newGroupName;
    @Inject
    private PerformRenameGroup.Factory performRenameGroupFactory;

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            this.performRenameGroupFactory.create().renameGroup(this.groupName, this.newGroupName);
        }
        catch (OrmException e) {
            throw this.die(e);
        }
        catch (InvalidNameException e) {
            throw this.die(e);
        }
        catch (NameAlreadyUsedException e) {
            throw this.die(e);
        }
        catch (NoSuchGroupException e) {
            throw this.die(e);
        }
    }
}

