/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AddSshKey;
import com.google.gerrit.server.account.CreateEmail;
import com.google.gerrit.server.account.DeleteActive;
import com.google.gerrit.server.account.DeleteEmail;
import com.google.gerrit.server.account.DeleteSshKey;
import com.google.gerrit.server.account.GetEmails;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gerrit.server.account.PutActive;
import com.google.gerrit.server.account.PutHttpPassword;
import com.google.gerrit.server.account.PutName;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="set-account", description="Change an account's settings")
final class SetAccountCommand
extends BaseCommand {
    @Argument(index=0, required=true, metaVar="USER", usage="full name, email-address, ssh username or account id")
    private Account.Id id;
    @Option(name="--full-name", metaVar="NAME", usage="display name of the account")
    private String fullName;
    @Option(name="--active", usage="set account's state to active")
    private boolean active;
    @Option(name="--inactive", usage="set account's state to inactive")
    private boolean inactive;
    @Option(name="--add-email", metaVar="EMAIL", usage="email addresses to add to the account")
    private List<String> addEmails = new ArrayList<String>();
    @Option(name="--delete-email", metaVar="EMAIL", usage="email addresses to delete from the account")
    private List<String> deleteEmails = new ArrayList<String>();
    @Option(name="--add-ssh-key", metaVar="-|KEY", usage="public keys to add to the account")
    private List<String> addSshKeys = new ArrayList<String>();
    @Option(name="--delete-ssh-key", metaVar="-|KEY", usage="public keys to delete from the account")
    private List<String> deleteSshKeys = new ArrayList<String>();
    @Option(name="--http-password", metaVar="PASSWORD", usage="password for HTTP authentication for the account")
    private String httpPassword;
    @Inject
    private IdentifiedUser currentUser;
    @Inject
    private IdentifiedUser.GenericFactory genericUserFactory;
    @Inject
    private CreateEmail.Factory createEmailFactory;
    @Inject
    private Provider<GetEmails> getEmailsProvider;
    @Inject
    private Provider<DeleteEmail> deleteEmailProvider;
    @Inject
    private Provider<PutName> putNameProvider;
    @Inject
    private Provider<PutHttpPassword> putHttpPasswordProvider;
    @Inject
    private Provider<PutActive> putActiveProvider;
    @Inject
    private Provider<DeleteActive> deleteActiveProvider;
    @Inject
    private Provider<AddSshKey> addSshKeyProvider;
    @Inject
    private Provider<GetSshKeys> getSshKeysProvider;
    @Inject
    private Provider<DeleteSshKey> deleteSshKeyProvider;
    private IdentifiedUser user;
    private AccountResource rsrc;

    SetAccountCommand() {
    }

    @Override
    public void start(Environment env) {
        this.startThread(new BaseCommand.CommandRunnable(){

            @Override
            public void run() throws Exception {
                if (!SetAccountCommand.this.currentUser.getCapabilities().canAdministrateServer()) {
                    String msg = String.format("fatal: %s does not have \"Administrator\" capability.", SetAccountCommand.this.currentUser.getUserName());
                    throw new BaseCommand.UnloggedFailure(1, msg);
                }
                SetAccountCommand.this.parseCommandLine();
                SetAccountCommand.this.validate();
                SetAccountCommand.this.setAccount();
            }
        });
    }

    private void validate() throws BaseCommand.UnloggedFailure {
        if (this.active && this.inactive) {
            throw new BaseCommand.UnloggedFailure(1, "--active and --inactive options are mutually exclusive.");
        }
        if (this.addSshKeys.contains("-") && this.deleteSshKeys.contains("-")) {
            throw new BaseCommand.UnloggedFailure(1, "Only one option may use the stdin");
        }
        if (this.deleteSshKeys.contains("ALL")) {
            this.deleteSshKeys = Collections.singletonList("ALL");
        }
        if (this.deleteEmails.contains("ALL")) {
            this.deleteEmails = Collections.singletonList("ALL");
        }
    }

    private void setAccount() throws OrmException, IOException, BaseCommand.UnloggedFailure {
        this.user = this.genericUserFactory.create(this.id);
        this.rsrc = new AccountResource(this.user);
        try {
            Object in;
            for (String email : this.addEmails) {
                this.addEmail(email);
            }
            for (String email : this.deleteEmails) {
                this.deleteEmail(email);
            }
            if (this.fullName != null) {
                in = new PutName.Input();
                ((PutName.Input)in).name = this.fullName;
                this.putNameProvider.get().apply(this.rsrc, (PutName.Input)in);
            }
            if (this.httpPassword != null) {
                in = new PutHttpPassword.Input();
                ((PutHttpPassword.Input)in).httpPassword = this.httpPassword;
                this.putHttpPasswordProvider.get().apply(this.rsrc, (PutHttpPassword.Input)in);
            }
            if (this.active) {
                this.putActiveProvider.get().apply(this.rsrc, null);
            } else if (this.inactive) {
                try {
                    this.deleteActiveProvider.get().apply(this.rsrc, null);
                }
                catch (ResourceNotFoundException e) {
                    // empty catch block
                }
            }
            this.addSshKeys = this.readSshKey(this.addSshKeys);
            if (!this.addSshKeys.isEmpty()) {
                this.addSshKeys(this.addSshKeys);
            }
            this.deleteSshKeys = this.readSshKey(this.deleteSshKeys);
            if (!this.deleteSshKeys.isEmpty()) {
                this.deleteSshKeys(this.deleteSshKeys);
            }
        }
        catch (RestApiException e) {
            throw this.die(e.getMessage());
        }
    }

    private void addSshKeys(List<String> sshKeys) throws RestApiException, BaseCommand.UnloggedFailure, OrmException, IOException {
        for (final String sshKey : sshKeys) {
            AddSshKey.Input in = new AddSshKey.Input();
            in.raw = new RawInput(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(sshKey.getBytes("UTF-8"));
                }

                @Override
                public String getContentType() {
                    return "plain/text";
                }

                @Override
                public long getContentLength() {
                    return sshKey.length();
                }
            };
            this.addSshKeyProvider.get().apply(this.rsrc, in);
        }
    }

    private void deleteSshKeys(List<String> sshKeys) throws RestApiException, OrmException {
        List<GetSshKeys.SshKeyInfo> infos = this.getSshKeysProvider.get().apply(this.rsrc);
        if (sshKeys.contains("ALL")) {
            for (GetSshKeys.SshKeyInfo i : infos) {
                this.deleteSshKey(i);
            }
        } else {
            for (String sshKey : sshKeys) {
                for (GetSshKeys.SshKeyInfo i : infos) {
                    if (!sshKey.trim().equals(i.sshPublicKey) && !sshKey.trim().equals(i.comment)) continue;
                    this.deleteSshKey(i);
                }
            }
        }
    }

    private void deleteSshKey(GetSshKeys.SshKeyInfo i) throws OrmException {
        AccountSshKey sshKey = new AccountSshKey(new AccountSshKey.Id(this.user.getAccountId(), i.seq), i.sshPublicKey);
        this.deleteSshKeyProvider.get().apply(new AccountResource.SshKey(this.user, sshKey), null);
    }

    private void addEmail(String email) throws BaseCommand.UnloggedFailure, RestApiException, OrmException {
        CreateEmail.Input in = new CreateEmail.Input();
        in.email = email;
        in.noConfirmation = true;
        try {
            this.createEmailFactory.create(email).apply(this.rsrc, in);
        }
        catch (EmailException e) {
            throw this.die(e.getMessage());
        }
    }

    private void deleteEmail(String email) throws BaseCommand.UnloggedFailure, RestApiException, OrmException {
        if (email.equals("ALL")) {
            List<GetEmails.EmailInfo> emails = this.getEmailsProvider.get().apply(this.rsrc);
            DeleteEmail deleteEmail = this.deleteEmailProvider.get();
            for (GetEmails.EmailInfo e : emails) {
                deleteEmail.apply(new AccountResource.Email(this.user, e.email), new DeleteEmail.Input());
            }
        } else {
            this.deleteEmailProvider.get().apply(new AccountResource.Email(this.user, email), new DeleteEmail.Input());
        }
    }

    private List<String> readSshKey(List<String> sshKeys) throws UnsupportedEncodingException, IOException {
        int idx;
        if (!sshKeys.isEmpty() && (idx = sshKeys.indexOf("-")) >= 0) {
            String line;
            String sshKey = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sshKey = sshKey + line + "\n";
            }
            sshKeys.set(idx, sshKey);
        }
        return sshKeys;
    }
}

