/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.DeleteIncludedGroups;
import com.google.gerrit.server.group.DeleteMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="set-members", description="Modify members of specific group or number of groups")
public class SetMembersCommand
extends SshCommand {
    @Option(name="--add", aliases={"-a"}, metaVar="USER", usage="users that should be added as group member")
    private List<Account.Id> accountsToAdd = Lists.newArrayList();
    @Option(name="--remove", aliases={"-r"}, metaVar="USER", usage="users that should be removed from the group")
    private List<Account.Id> accountsToRemove = Lists.newArrayList();
    @Option(name="--include", aliases={"-i"}, metaVar="GROUP", usage="group that should be included as group member")
    private List<AccountGroup.UUID> groupsToInclude = Lists.newArrayList();
    @Option(name="--exclude", aliases={"-e"}, metaVar="GROUP", usage="group that should be excluded from the group")
    private List<AccountGroup.UUID> groupsToRemove = Lists.newArrayList();
    @Argument(index=0, required=true, multiValued=true, metaVar="GROUP", usage="groups to modify")
    private List<AccountGroup.UUID> groups = Lists.newArrayList();
    @Inject
    private Provider<AddMembers> addMembers;
    @Inject
    private Provider<DeleteMembers> deleteMembers;
    @Inject
    private Provider<AddIncludedGroups> addIncludedGroups;
    @Inject
    private Provider<DeleteIncludedGroups> deleteIncludedGroups;
    @Inject
    private GroupsCollection groupsCollection;
    @Inject
    private GroupCache groupCache;
    @Inject
    private AccountCache accountCache;

    @Override
    protected void run() throws BaseCommand.UnloggedFailure, BaseCommand.Failure, Exception {
        for (AccountGroup.UUID groupUuid : this.groups) {
            GroupResource resource = this.groupsCollection.parse(TopLevelResource.INSTANCE, IdString.fromUrl(groupUuid.get()));
            if (!this.accountsToRemove.isEmpty()) {
                this.deleteMembers.get().apply(resource, this.fromMembers(this.accountsToRemove));
                this.reportMembersAction("removed from", resource, this.accountsToRemove);
            }
            if (!this.groupsToRemove.isEmpty()) {
                this.deleteIncludedGroups.get().apply(resource, this.fromGroups(this.groupsToRemove));
                this.reportGroupsAction("excluded from", resource, this.groupsToRemove);
            }
            if (!this.accountsToAdd.isEmpty()) {
                this.addMembers.get().apply(resource, this.fromMembers(this.accountsToAdd));
                this.reportMembersAction("added to", resource, this.accountsToAdd);
            }
            if (this.groupsToInclude.isEmpty()) continue;
            this.addIncludedGroups.get().apply(resource, this.fromGroups(this.groupsToInclude));
            this.reportGroupsAction("included to", resource, this.groupsToInclude);
        }
    }

    private void reportMembersAction(String action, GroupResource group, List<Account.Id> accountIdList) throws UnsupportedEncodingException, IOException {
        this.out.write(String.format("Members %s group %s: %s\n", action, group.getName(), Joiner.on(", ").join(Iterables.transform(accountIdList, new Function<Account.Id, String>(){

            @Override
            public String apply(Account.Id accountId) {
                return Objects.firstNonNull(SetMembersCommand.this.accountCache.get(accountId).getAccount().getPreferredEmail(), "n/a");
            }
        }))).getBytes("UTF-8"));
    }

    private void reportGroupsAction(String action, GroupResource group, List<AccountGroup.UUID> groupUuidList) throws UnsupportedEncodingException, IOException {
        this.out.write(String.format("Groups %s group %s: %s\n", action, group.getName(), Joiner.on(", ").join(Iterables.transform(groupUuidList, new Function<AccountGroup.UUID, String>(){

            @Override
            public String apply(AccountGroup.UUID uuid) {
                return SetMembersCommand.this.groupCache.get(uuid).getName();
            }
        }))).getBytes("UTF-8"));
    }

    private AddIncludedGroups.Input fromGroups(List<AccountGroup.UUID> accounts) {
        return AddIncludedGroups.Input.fromGroups(Lists.newArrayList(Iterables.transform(accounts, new Function<AccountGroup.UUID, String>(){

            @Override
            public String apply(AccountGroup.UUID uuid) {
                return uuid.toString();
            }
        })));
    }

    private AddMembers.Input fromMembers(List<Account.Id> accounts) {
        return AddMembers.Input.fromMembers(Lists.newArrayList(Iterables.transform(accounts, new Function<Account.Id, String>(){

            @Override
            public String apply(Account.Id id) {
                return id.toString();
            }
        })));
    }
}

