/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.DeleteReviewer;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="set-reviewers", description="Add or remove reviewers on a change")
public class SetReviewersCommand
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(SetReviewersCommand.class);
    @Option(name="--project", aliases={"-p"}, usage="project containing the change")
    private ProjectControl projectControl;
    @Option(name="--add", aliases={"-a"}, metaVar="REVIEWER", usage="user or group that should be added as reviewer")
    private List<String> toAdd = new ArrayList<String>();
    @Inject
    private ReviewDb db;
    @Inject
    private ReviewerResource.Factory reviewerFactory;
    @Inject
    private Provider<PostReviewers> postReviewersProvider;
    @Inject
    private Provider<DeleteReviewer> deleteReviewerProvider;
    @Inject
    private ChangeControl.Factory changeControlFactory;
    @Inject
    private ChangesCollection changesCollection;
    private Set<Account.Id> toRemove = new HashSet<Account.Id>();
    private Set<Change.Id> changes = new HashSet<Change.Id>();

    @Option(name="--remove", aliases={"-r"}, metaVar="REVIEWER", usage="user that should be removed from the reviewer list")
    void optionRemove(Account.Id who) {
        this.toRemove.add(who);
    }

    @Argument(index=0, required=true, multiValued=true, metaVar="COMMIT", usage="changes to modify")
    void addChange(String token) {
        try {
            this.changes.addAll(this.parseChangeId(token));
        }
        catch (BaseCommand.UnloggedFailure e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (OrmException e) {
            throw new IllegalArgumentException("database is down", e);
        }
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        boolean ok = true;
        for (Change.Id changeId : this.changes) {
            try {
                ok &= this.modifyOne(changeId);
            }
            catch (Exception err) {
                ok = false;
                log.error("Error updating reviewers on change " + changeId, err);
                this.writeError("fatal", "internal error while updating " + changeId);
            }
        }
        if (!ok) {
            throw SetReviewersCommand.error("fatal: one or more updates failed; review output above");
        }
    }

    private boolean modifyOne(Change.Id changeId) throws Exception {
        ChangeResource changeRsrc = this.changesCollection.parse(changeId);
        boolean ok = true;
        DeleteReviewer delete = this.deleteReviewerProvider.get();
        for (Account.Id reviewer : this.toRemove) {
            ReviewerResource rsrc = this.reviewerFactory.create(changeRsrc, reviewer);
            String error = null;
            try {
                delete.apply(rsrc, new DeleteReviewer.Input());
            }
            catch (ResourceNotFoundException e) {
                error = String.format("could not remove %s: not found", reviewer);
            }
            catch (Exception e) {
                error = String.format("could not remove %s: %s", reviewer, e.getMessage());
            }
            if (error == null) continue;
            ok = false;
            this.writeError("error", error);
        }
        PostReviewers post = this.postReviewersProvider.get();
        for (String reviewer : this.toAdd) {
            String error;
            AddReviewerInput input = new AddReviewerInput();
            input.reviewer = reviewer;
            input.confirmed = true;
            try {
                error = post.apply((ChangeResource)changeRsrc, (AddReviewerInput)input).error;
            }
            catch (Exception e) {
                error = String.format("could not add %s: %s", reviewer, e.getMessage());
            }
            if (error == null) continue;
            ok = false;
            this.writeError("error", error);
        }
        return ok;
    }

    private Set<Change.Id> parseChangeId(String idstr) throws BaseCommand.UnloggedFailure, OrmException {
        HashSet<Change.Id> matched = new HashSet<Change.Id>(4);
        boolean isCommit = idstr.matches("^([0-9a-fA-F]{4,40})$");
        boolean changeKeyParses = false;
        if (idstr.matches("^I[0-9a-fA-F]*$")) {
            Change.Key key;
            try {
                key = Change.Key.parse(idstr);
                changeKeyParses = true;
            }
            catch (IllegalArgumentException e) {
                key = null;
                changeKeyParses = false;
            }
            if (changeKeyParses) {
                for (Change change : this.db.changes().byKeyRange(key, key.max())) {
                    this.matchChange(matched, change);
                }
            }
        }
        if (isCommit) {
            RevId id = new RevId(idstr);
            ResultSet<PatchSet> patches = id.isComplete() ? this.db.patchSets().byRevision(id) : this.db.patchSets().byRevisionRange(id, id.max());
            for (PatchSet ps : patches) {
                this.matchChange(matched, ps.getId().getParentKey());
            }
        }
        boolean changeIdParses = false;
        if (idstr.matches("^[1-9][0-9]*$")) {
            Change.Id id;
            try {
                id = Change.Id.parse(idstr);
                changeIdParses = true;
            }
            catch (IllegalArgumentException e) {
                id = null;
                changeIdParses = false;
            }
            if (changeIdParses) {
                this.matchChange(matched, id);
            }
        }
        if (!(changeKeyParses || isCommit || changeIdParses)) {
            throw SetReviewersCommand.error("\"" + idstr + "\" is not a valid change");
        }
        switch (matched.size()) {
            case 0: {
                throw SetReviewersCommand.error("\"" + idstr + "\" no such change");
            }
            case 1: {
                return matched;
            }
        }
        throw SetReviewersCommand.error("\"" + idstr + "\" matches multiple changes");
    }

    private void matchChange(Set<Change.Id> matched, Change.Id changeId) {
        if (changeId != null && !matched.contains(changeId)) {
            try {
                this.matchChange(matched, this.db.changes().get(changeId));
            }
            catch (OrmException e) {
                log.warn("Error reading change " + changeId, e);
            }
        }
    }

    private void matchChange(Set<Change.Id> matched, Change change) {
        try {
            if (change != null && this.inProject(change) && this.changeControlFactory.controlFor(change).isVisible(this.db)) {
                matched.add(change.getId());
            }
        }
        catch (NoSuchChangeException e) {
        }
        catch (OrmException e) {
            log.warn("Error reading change " + change.getId(), e);
        }
    }

    private boolean inProject(Change change) {
        if (this.projectControl != null) {
            return this.projectControl.getProject().getNameKey().equals(change.getProject());
        }
        return true;
    }

    private void writeError(String type, String msg) {
        try {
            this.err.write((type + ": " + msg + "\n").getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BaseCommand.UnloggedFailure error(String msg) {
        return new BaseCommand.UnloggedFailure(1, msg);
    }
}

