/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Objects;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ListTasks;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Option;

@AdminHighPriorityCommand
@CommandMetaData(name="show-queue", description="Display the background work queues", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class ShowQueue
extends SshCommand {
    @Option(name="--wide", aliases={"-w"}, usage="display without line width truncation")
    private boolean wide;
    @Inject
    private ListTasks listTasks;
    @Inject
    private IdentifiedUser currentUser;
    private int columns = 80;
    private int taskNameWidth;

    ShowQueue() {
    }

    @Override
    public void start(Environment env) throws IOException {
        String s = env.getEnv().get("COLUMNS");
        if (s != null && !s.isEmpty()) {
            try {
                this.columns = Integer.parseInt(s);
            }
            catch (NumberFormatException err) {
                this.columns = 80;
            }
        }
        super.start(env);
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        this.taskNameWidth = this.wide ? Integer.MAX_VALUE : this.columns - 8 - 12 - 12 - 4 - 4;
        this.stdout.print(String.format("%-8s %-12s %-12s %-4s %s\n", "Task", "State", "StartTime", "", "Command"));
        this.stdout.print("------------------------------------------------------------------------------\n");
        try {
            List<ListTasks.TaskInfo> tasks = this.listTasks.apply(new ConfigResource());
            long now = TimeUtil.nowMs();
            boolean viewAll = this.currentUser.getCapabilities().canViewQueue();
            for (ListTasks.TaskInfo task : tasks) {
                String start;
                switch (task.state) {
                    case DONE: 
                    case CANCELLED: 
                    case RUNNING: 
                    case READY: {
                        start = ShowQueue.format(task.state);
                        break;
                    }
                    default: {
                        start = ShowQueue.time(now, task.delay);
                    }
                }
                if (viewAll || task.projectName == null) {
                    String command = task.command.length() < this.taskNameWidth ? task.command : task.command.substring(0, this.taskNameWidth);
                    this.stdout.print(String.format("%8s %-12s %-12s %-4s %s\n", task.id, start, ShowQueue.startTime(task.startTime), "", command));
                    continue;
                }
                String remoteName = task.remoteName != null ? task.remoteName + "/" + task.projectName : task.projectName;
                this.stdout.print(String.format("%8s %-12s %-4s %s\n", task.id, start, ShowQueue.startTime(task.startTime), Objects.firstNonNull(remoteName, "n/a")));
            }
            this.stdout.print("------------------------------------------------------------------------------\n");
            this.stdout.print("  " + tasks.size() + " tasks\n");
        }
        catch (AuthException e) {
            throw this.die(e);
        }
    }

    private static String time(long now, long delay) {
        Date when = new Date(now + delay);
        return ShowQueue.format(when, delay);
    }

    private static String startTime(Date when) {
        return ShowQueue.format(when, TimeUtil.nowMs() - when.getTime());
    }

    private static String format(Date when, long timeFromNow) {
        if (timeFromNow < 86400000L) {
            return new SimpleDateFormat("HH:mm:ss.SSS").format(when);
        }
        return new SimpleDateFormat("MMM-dd HH:mm").format(when);
    }

    private static String format(WorkQueue.Task.State state) {
        switch (state) {
            case DONE: {
                return "....... done";
            }
            case CANCELLED: {
                return "..... killed";
            }
            case RUNNING: {
                return "";
            }
            case READY: {
                return "waiting ....";
            }
            case SLEEPING: {
                return "sleeping";
            }
        }
        return state.toString();
    }
}

