/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.ChangeListener;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.events.ChangeEvent;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.StreamCommandExecutor;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sshd.server.Environment;

@RequiresCapability(value="streamEvents")
@CommandMetaData(name="stream-events", description="Monitor events occurring in real time", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class StreamEvents
extends BaseCommand {
    private static final int MAX_EVENTS = 128;
    private static final int BATCH_SIZE = 32;
    @Inject
    private IdentifiedUser currentUser;
    @Inject
    private ChangeHooks hooks;
    @Inject
    @StreamCommandExecutor
    private WorkQueue.Executor pool;
    private final LinkedBlockingQueue<ChangeEvent> queue = new LinkedBlockingQueue(128);
    private final Gson gson = new Gson();
    private final Object droppedOutputEvent = new Object(){
        final String type = "dropped-output";
    };
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void onChangeEvent(ChangeEvent event) {
            StreamEvents.this.offer(event);
        }
    };
    private final WorkQueue.CancelableRunnable writer = new WorkQueue.CancelableRunnable(){

        @Override
        public void run() {
            StreamEvents.this.writeEvents();
        }

        @Override
        public void cancel() {
            StreamEvents.this.onExit(0);
        }
    };
    private volatile boolean dropped;
    private final Object taskLock = new Object();
    private boolean done;
    private Future<?> task;
    private PrintWriter stdout;

    StreamEvents() {
    }

    @Override
    public void start(Environment env) throws IOException {
        try {
            this.parseCommandLine();
        }
        catch (BaseCommand.UnloggedFailure e) {
            String msg = e.getMessage();
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            this.err.write(msg.getBytes("UTF-8"));
            this.err.flush();
            this.onExit(1);
            return;
        }
        this.stdout = StreamEvents.toPrintWriter(this.out);
        this.hooks.addChangeListener(this.listener, this.currentUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onExit(int rc) {
        this.hooks.removeChangeListener(this.listener);
        Object object = this.taskLock;
        synchronized (object) {
            this.done = true;
        }
        super.onExit(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        boolean exit;
        this.hooks.removeChangeListener(this.listener);
        Object object = this.taskLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
                exit = false;
            } else {
                exit = !this.done;
            }
            this.done = true;
        }
        if (exit) {
            this.onExit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offer(ChangeEvent event) {
        Object object = this.taskLock;
        synchronized (object) {
            if (!this.queue.offer(event)) {
                this.dropped = true;
            }
            if (this.task == null && !this.done) {
                this.task = this.pool.submit(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeEvent poll() {
        Object object = this.taskLock;
        synchronized (object) {
            ChangeEvent event = this.queue.poll();
            if (event == null) {
                this.task = null;
            }
            return event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEvents() {
        int processed;
        for (processed = 0; processed < 32; ++processed) {
            ChangeEvent event;
            if (Thread.interrupted() || this.stdout.checkError()) {
                this.hooks.removeChangeListener(this.listener);
                this.flush();
                this.onExit(0);
                return;
            }
            if (this.dropped) {
                this.write(this.droppedOutputEvent);
                this.dropped = false;
            }
            if ((event = this.poll()) == null) break;
            this.write(event);
        }
        this.flush();
        if (32 <= processed) {
            Object object = this.taskLock;
            synchronized (object) {
                this.task = this.pool.submit(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Object message) {
        String msg = this.gson.toJson(message) + "\n";
        PrintWriter printWriter = this.stdout;
        synchronized (printWriter) {
            this.stdout.print(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        PrintWriter printWriter = this.stdout;
        synchronized (printWriter) {
            this.stdout.flush();
        }
    }
}

