/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.util.cli;

import com.google.gerrit.util.cli.OptionHandlerFactory;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.kohsuke.args4j.spi.OptionHandler;

public class OptionHandlerUtil {
    public static <T> Key<OptionHandlerFactory<T>> keyFor(Class<T> valueType) {
        ParameterizedType factoryType = Types.newParameterizedType(OptionHandlerFactory.class, new Type[]{valueType});
        return Key.get(factoryType);
    }

    private static <T> Key<OptionHandler<T>> handlerOf(Class<T> type) {
        ParameterizedType handlerType = Types.newParameterizedTypeWithOwner(null, OptionHandler.class, new Type[]{type});
        return Key.get(handlerType);
    }

    public static <T> Module moduleFor(Class<T> type, Class<? extends OptionHandler<T>> impl) {
        return new FactoryModuleBuilder().implement(OptionHandlerUtil.handlerOf(type), impl).build(OptionHandlerUtil.keyFor(type));
    }

    private OptionHandlerUtil() {
    }
}

