/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtexpui.server;

import com.google.gwtexpui.server.CacheHeaders;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheControlFilter
implements Filter {
    @Override
    public void init(FilterConfig config) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest sreq, ServletResponse srsp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse rsp = (HttpServletResponse)srsp;
        String pathInfo = CacheControlFilter.pathInfo(req);
        if (CacheControlFilter.cacheForever(pathInfo, req)) {
            CacheHeaders.setCacheable(req, rsp, 365L, TimeUnit.DAYS);
        } else if (CacheControlFilter.nocache(pathInfo)) {
            CacheHeaders.setNotCacheable(rsp);
        }
        chain.doFilter(req, rsp);
    }

    private static boolean cacheForever(String pathInfo, HttpServletRequest req) {
        if (pathInfo.endsWith(".cache.html") || pathInfo.endsWith(".cache.gif") || pathInfo.endsWith(".cache.png") || pathInfo.endsWith(".cache.css") || pathInfo.endsWith(".cache.jar") || pathInfo.endsWith(".cache.swf") || pathInfo.endsWith(".cache.txt") || pathInfo.endsWith(".cache.js")) {
            return true;
        }
        if (pathInfo.endsWith(".nocache.js")) {
            String v = req.getParameter("content");
            return v != null && v.length() > 20;
        }
        return false;
    }

    private static boolean nocache(String pathInfo) {
        return pathInfo.endsWith(".nocache.js");
    }

    private static String pathInfo(HttpServletRequest req) {
        String ctx;
        String uri = req.getRequestURI();
        return uri.startsWith(ctx = req.getContextPath()) ? uri.substring(ctx.length()) : uri;
    }
}

