/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwtjsonrpc.client.JsonDefTarget;
import com.google.gwtjsonrpc.client.XsrfManager;
import com.google.gwtjsonrpc.client.event.BaseRpcEvent;
import com.google.gwtjsonrpc.client.event.RpcCompleteEvent;
import com.google.gwtjsonrpc.client.event.RpcCompleteHandler;
import com.google.gwtjsonrpc.client.event.RpcStartEvent;
import com.google.gwtjsonrpc.client.event.RpcStartHandler;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.RemoteJsonService;

public class JsonUtil {
    private static final HandlerManager globalHandlers = new HandlerManager(null);
    private static XsrfManager xsrfManager = new XsrfManager(){
        private String token;

        @Override
        public String getToken(JsonDefTarget proxy) {
            return this.token;
        }

        @Override
        public void setToken(JsonDefTarget proxy, String token) {
            this.token = token;
        }
    };
    private static final XsrfManager defaultXsrfManager = new XsrfManager(){

        @Override
        public String getToken(JsonDefTarget proxy) {
            return xsrfManager.getToken(proxy);
        }

        @Override
        public void setToken(JsonDefTarget proxy, String token) {
            xsrfManager.setToken(proxy, token);
        }
    };

    public static XsrfManager getDefaultXsrfManager() {
        return defaultXsrfManager;
    }

    public static void setDefaultXsrfManager(XsrfManager m) {
        assert (m != null);
        xsrfManager = m;
    }

    public static <T extends RemoteJsonService> T bind(T imp, String path) {
        assert (GWT.isClient());
        assert (imp instanceof ServiceDefTarget);
        String base = GWT.getModuleBaseURL();
        ((ServiceDefTarget)imp).setServiceEntryPoint(base + path);
        return imp;
    }

    public static HandlerRegistration addRpcStartHandler(RpcStartHandler h) {
        return globalHandlers.addHandler(RpcStartEvent.getType(), (EventHandler)h);
    }

    public static HandlerRegistration addRpcCompleteHandler(RpcCompleteHandler h) {
        return globalHandlers.addHandler(RpcCompleteEvent.getType(), (EventHandler)h);
    }

    public static void fireEvent(BaseRpcEvent<?> event) {
        globalHandlers.fireEvent(event);
    }

    public static <T> void invoke(ResultDeserializer<T> resultDeserializer, AsyncCallback<T> callback, JavaScriptObject rpcResult) {
        T result;
        try {
            result = resultDeserializer.fromResult(rpcResult);
        }
        catch (RuntimeException e) {
            callback.onFailure((Throwable)new InvocationException("Invalid JSON Response", (Throwable)e));
            return;
        }
        callback.onSuccess(result);
    }

    private JsonUtil() {
    }
}

