/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.v2_0;

import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwtjsonrpc.client.impl.AbstractJsonProxy;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.v2_0.JsonCall20;
import com.google.gwtjsonrpc.common.AsyncCallback;

public class JsonCall20HttpPost<T>
extends JsonCall20<T> {
    public JsonCall20HttpPost(AbstractJsonProxy abstractJsonProxy, String methodName, String requestParams, ResultDeserializer<T> resultDeserializer, AsyncCallback<T> callback) {
        super(abstractJsonProxy, methodName, requestParams, resultDeserializer, callback);
    }

    @Override
    protected void send() {
        this.requestId = ++lastRequestId;
        StringBuilder body = new StringBuilder();
        body.append("{\"jsonrpc\":\"2.0\",\"method\":\"");
        body.append(this.methodName);
        body.append("\",\"params\":");
        body.append(this.requestParams);
        body.append(",\"id\":").append(this.requestId);
        String xsrfKey = this.proxy.getXsrfManager().getToken(this.proxy);
        if (xsrfKey != null) {
            body.append(",\"xsrfKey\":");
            body.append(JsonUtils.escapeValue((String)xsrfKey));
        }
        body.append("}");
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, this.proxy.getServiceEntryPoint());
        rb.setHeader("Content-Type", "application/json; charset=utf-8");
        rb.setHeader("Accept", "application/json,application/json,application/jsonrequest");
        rb.setCallback((RequestCallback)this);
        rb.setRequestData(body.toString());
        this.send(rb);
    }
}

