/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.common;

import java.sql.Timestamp;
import java.util.Date;

public class JavaSqlTimestampHelper {
    public static Timestamp parseTimestamp(String s) {
        int ns;
        int ss;
        int mi;
        int hh;
        int dd;
        int mm;
        int yy;
        String[] components = s.split(" ");
        if (components.length < 1 || components.length > 3) {
            throw new IllegalArgumentException("Expected date and optional time: " + s);
        }
        String date = components[0];
        String time = components.length >= 2 ? components[1] : null;
        int off = components.length == 3 ? JavaSqlTimestampHelper.parseTimeZone(components[2]) : 0;
        String[] dSplit = date.split("-");
        if (dSplit.length != 3) {
            throw new IllegalArgumentException("Invalid date format: " + date);
        }
        try {
            yy = Integer.parseInt(dSplit[0]) - 1900;
            mm = Integer.parseInt(dSplit[1]) - 1;
            dd = Integer.parseInt(dSplit[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid date format: " + date, e);
        }
        if (time != null) {
            int p = time.indexOf(46);
            try {
                double f;
                String t;
                if (p >= 0) {
                    t = time.substring(0, p);
                    f = Double.parseDouble("0." + time.substring(p + 1));
                } else {
                    t = time;
                    f = 0.0;
                }
                String[] tSplit = t.split(":");
                if (tSplit.length != 3) {
                    throw new IllegalArgumentException("Invalid time format: " + time);
                }
                hh = Integer.parseInt(tSplit[0]);
                mi = Integer.parseInt(tSplit[1]);
                ss = Integer.parseInt(tSplit[2]);
                ns = (int)Math.round(f * 1.0E9);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid time format: " + time, e);
            }
        } else {
            hh = 0;
            mi = 0;
            ss = 0;
            ns = 0;
        }
        Timestamp result = new Timestamp(Date.UTC(yy, mm, dd, hh, mi, ss) - (long)off);
        result.setNanos(ns);
        return result;
    }

    public static boolean hasTime(String s) {
        return s.indexOf(32) > 0;
    }

    public static boolean hasTimeZone(String s) {
        return s.indexOf(32) != s.lastIndexOf(32);
    }

    private static int parseTimeZone(String s) {
        if (s.length() != 5 || s.charAt(0) != '-' && s.charAt(0) != '+') {
            throw new IllegalArgumentException("Invalid time zone: " + s);
        }
        for (int i = 1; i < s.length(); ++i) {
            if (s.charAt(i) >= '0' && s.charAt(i) <= '9') continue;
            throw new IllegalArgumentException("Invalid time zone: " + s);
        }
        int off = (s.charAt(0) == '-' ? -1 : 1) * 60 * 1000 * (60 * Integer.parseInt(s.substring(1, 3)) + Integer.parseInt(s.substring(3, 5)));
        return off;
    }

    private JavaSqlTimestampHelper() {
    }
}

