/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class MapDeserializer
implements JsonDeserializer<Map<Object, Object>>,
JsonSerializer<Map<Object, Object>>,
InstanceCreator<Map<Object, Object>> {
    @Override
    public Map<Object, Object> createInstance(Type type) {
        return new HashMap<Object, Object>();
    }

    @Override
    public Map<Object, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Type kt = ((ParameterizedType)typeOfT).getActualTypeArguments()[0];
        Type vt = ((ParameterizedType)typeOfT).getActualTypeArguments()[1];
        if (json.isJsonNull()) {
            return null;
        }
        if (kt == String.class) {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Expected object for map type");
            }
            JsonObject p = (JsonObject)json;
            Object r = this.createInstance(typeOfT);
            for (Map.Entry<String, JsonElement> e : p.entrySet()) {
                Object v = context.deserialize(e.getValue(), vt);
                r.put(e.getKey(), v);
            }
            return r;
        }
        if (!json.isJsonArray()) {
            throw new JsonParseException("Expected array for map type");
        }
        JsonArray p = (JsonArray)json;
        Object r = this.createInstance(typeOfT);
        int n = 0;
        while (n < p.size()) {
            Object k = context.deserialize(p.get(n++), kt);
            Object v = context.deserialize(p.get(n++), vt);
            r.put(k, v);
        }
        return r;
    }

    @Override
    public JsonElement serialize(Map<Object, Object> src, Type typeOfSrc, JsonSerializationContext context) {
        Type kt = ((ParameterizedType)typeOfSrc).getActualTypeArguments()[0];
        Type vt = ((ParameterizedType)typeOfSrc).getActualTypeArguments()[1];
        if (src == null) {
            return new JsonNull();
        }
        if (kt == String.class) {
            JsonObject r = new JsonObject();
            for (Map.Entry<Object, Object> e : src.entrySet()) {
                r.add(e.getKey().toString(), context.serialize(e.getValue(), vt));
            }
            return r;
        }
        JsonArray r = new JsonArray();
        for (Map.Entry<Object, Object> e : src.entrySet()) {
            r.add(context.serialize(e.getKey(), kt));
            r.add(context.serialize(e.getValue(), vt));
        }
        return r;
    }
}

